/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.math;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDAFEvaluator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;

@Description(name="l2_norm", value="_FUNC_(double x) - Return a L2 norm of the given input x.", extended="WITH input as (\n  select generate_series(1,3) as v\n)\nselect l2_norm(v) as l2norm\nfrom input;\n3.7416573867739413 = sqrt(1^2+2^2+3^2))")
public final class L2NormUDAF
extends UDAF {

    public static class PartialResult {
        double squaredSum = 0.0;

        PartialResult() {
        }

        void iterate(double xi) {
            this.squaredSum += xi * xi;
        }

        void merge(PartialResult other) {
            this.squaredSum += other.squaredSum;
        }

        double get() {
            return Math.sqrt(this.squaredSum);
        }
    }

    public static class Evaluator
    implements UDAFEvaluator {
        private PartialResult partial;

        public void init() {
            this.partial = null;
        }

        public boolean iterate(DoubleWritable xi) throws HiveException {
            if (xi == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
            }
            this.partial.iterate(xi.get());
            return true;
        }

        public PartialResult terminatePartial() {
            return this.partial;
        }

        public boolean merge(PartialResult other) throws HiveException {
            if (other == null) {
                return true;
            }
            if (this.partial == null) {
                this.partial = new PartialResult();
            }
            this.partial.merge(other);
            return true;
        }

        public double terminate() {
            if (this.partial == null) {
                return 0.0;
            }
            return this.partial.get();
        }
    }
}

