/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.math;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.math.MathUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorUtils;
import org.apache.hadoop.io.FloatWritable;

@Description(name="sigmoid", value="_FUNC_(x) - Returns 1.0 / (1.0 + exp(-x))", extended="WITH input as (\n  SELECT 3.0 as x\n  UNION ALL\n  SELECT -3.0 as x\n)\nselect \n  1.0 / (1.0 + exp(-x)),\n  sigmoid(x)\nfrom\n  input;\n0.04742587317756678   0.04742587357759476\n0.9525741268224334    0.9525741338729858")
@UDFType(deterministic=true, stateful=false)
public final class SigmoidGenericUDF
extends GenericUDF {
    private PrimitiveObjectInspector argOI;

    public ObjectInspector initialize(@Nonnull ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1) {
            throw new UDFArgumentException("_FUNC_ takes 1 argument");
        }
        this.argOI = HiveUtils.asDoubleCompatibleOI(argOIs[0]);
        return PrimitiveObjectInspectorFactory.writableFloatObjectInspector;
    }

    @Nullable
    public FloatWritable evaluate(@Nonnull GenericUDF.DeferredObject[] arguments) throws HiveException {
        assert (arguments.length == 1) : "sigmoid takes 1 argument: " + arguments.length;
        GenericUDF.DeferredObject arg0 = arguments[0];
        assert (arg0 != null);
        Object obj0 = arg0.get();
        if (obj0 == null) {
            return null;
        }
        double x = PrimitiveObjectInspectorUtils.getDouble((Object)obj0, (PrimitiveObjectInspector)this.argOI);
        float v = (float)MathUtils.sigmoid(x);
        return new FloatWritable(v);
    }

    public String getDisplayString(String[] children) {
        return "sigmoid(" + Arrays.toString(children) + ')';
    }
}

