/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.matrix;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.hadoop.WritableUtils;
import hivemall.utils.lang.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.udf.generic.AbstractGenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFParameterInfo;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;

@Description(name="transpose_and_dot", value="_FUNC_(array<number> X, array<number> Y) - Returns dot(X.T, Y) as array<array<double>>, shape = (X.#cols, Y.#cols)", extended="WITH input as (\n  select array(1.0, 2.0, 3.0, 4.0) as x, array(1, 2) as y\n  UNION ALL\n  select array(2.0, 3.0, 4.0, 5.0) as x, array(1, 2) as y\n)\nselect\n  transpose_and_dot(x, y) as xy,\n  transpose_and_dot(y, x) as yx\nfrom \n  input;\n\n[[\"3.0\",\"6.0\"],[\"5.0\",\"10.0\"],[\"7.0\",\"14.0\"],[\"9.0\",\"18.0\"]]   [[\"3.0\",\"5.0\",\"7.0\",\"9.0\"],[\"6.0\",\"10.0\",\"14.0\",\"18.0\"]]\n")
public final class TransposeAndDotUDAF
extends AbstractGenericUDAFResolver {
    public GenericUDAFEvaluator getEvaluator(GenericUDAFParameterInfo info) throws SemanticException {
        ObjectInspector[] OIs = info.getParameterObjectInspectors();
        if (OIs.length != 2) {
            throw new UDFArgumentLengthException("Specify two arguments.");
        }
        if (!HiveUtils.isNumberListOI(OIs[0])) {
            throw new UDFArgumentTypeException(0, "Only array<number> type argument is acceptable but " + OIs[0].getTypeName() + " was passed as `matrix0_row`");
        }
        if (!HiveUtils.isNumberListOI(OIs[1])) {
            throw new UDFArgumentTypeException(1, "Only array<number> type argument is acceptable but " + OIs[1].getTypeName() + " was passed as `matrix1_row`");
        }
        return new TransposeAndDotUDAFEvaluator();
    }

    static final class TransposeAndDotUDAFEvaluator
    extends GenericUDAFEvaluator {
        private ListObjectInspector xRowOI;
        private PrimitiveObjectInspector xElemOI;
        private ListObjectInspector yRowOI;
        private PrimitiveObjectInspector yElemOI;
        private ListObjectInspector aggMatrixOI;
        private ListObjectInspector aggMatrixRowOI;
        private DoubleObjectInspector aggMatrixElemOI;
        private double[] xRow;
        private double[] yRow;

        TransposeAndDotUDAFEvaluator() {
        }

        public ObjectInspector init(GenericUDAFEvaluator.Mode mode, ObjectInspector[] OIs) throws HiveException {
            super.init(mode, OIs);
            if (mode == GenericUDAFEvaluator.Mode.PARTIAL1 || mode == GenericUDAFEvaluator.Mode.COMPLETE) {
                this.xRowOI = HiveUtils.asListOI(OIs[0]);
                this.xElemOI = HiveUtils.asDoubleCompatibleOI(this.xRowOI.getListElementObjectInspector());
                this.yRowOI = HiveUtils.asListOI(OIs[1]);
                this.yElemOI = HiveUtils.asDoubleCompatibleOI(this.yRowOI.getListElementObjectInspector());
            } else {
                this.aggMatrixOI = HiveUtils.asListOI(OIs[0]);
                this.aggMatrixRowOI = HiveUtils.asListOI(this.aggMatrixOI.getListElementObjectInspector());
                this.aggMatrixElemOI = HiveUtils.asDoubleOI(this.aggMatrixRowOI.getListElementObjectInspector());
            }
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)PrimitiveObjectInspectorFactory.writableDoubleObjectInspector));
        }

        public GenericUDAFEvaluator.AbstractAggregationBuffer getNewAggregationBuffer() throws HiveException {
            TransposeAndDotAggregationBuffer myAgg = new TransposeAndDotAggregationBuffer();
            this.reset((GenericUDAFEvaluator.AggregationBuffer)myAgg);
            return myAgg;
        }

        public void reset(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            TransposeAndDotAggregationBuffer myAgg = (TransposeAndDotAggregationBuffer)agg;
            myAgg.reset();
        }

        public void iterate(GenericUDAFEvaluator.AggregationBuffer agg, Object[] parameters) throws HiveException {
            Object matrix0RowObj = parameters[0];
            Object matrix1RowObj = parameters[1];
            Preconditions.checkNotNull(matrix0RowObj, UDFArgumentException.class);
            Preconditions.checkNotNull(matrix1RowObj, UDFArgumentException.class);
            TransposeAndDotAggregationBuffer myAgg = (TransposeAndDotAggregationBuffer)agg;
            if (this.xRow == null) {
                this.xRow = new double[this.xRowOI.getListLength(matrix0RowObj)];
            }
            if (this.yRow == null) {
                this.yRow = new double[this.yRowOI.getListLength(matrix1RowObj)];
            }
            HiveUtils.toDoubleArray(matrix0RowObj, this.xRowOI, this.xElemOI, this.xRow, false);
            HiveUtils.toDoubleArray(matrix1RowObj, this.yRowOI, this.yElemOI, this.yRow, false);
            if (myAgg.aggMatrix == null) {
                myAgg.init(this.xRow.length, this.yRow.length);
            }
            for (int i = 0; i < this.xRow.length; ++i) {
                for (int j = 0; j < this.yRow.length; ++j) {
                    double[] dArray = myAgg.aggMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.xRow[i] * this.yRow[j];
                }
            }
        }

        public void merge(GenericUDAFEvaluator.AggregationBuffer agg, Object other) throws HiveException {
            if (other == null) {
                return;
            }
            TransposeAndDotAggregationBuffer myAgg = (TransposeAndDotAggregationBuffer)agg;
            List matrix = this.aggMatrixOI.getList(other);
            int n = matrix.size();
            double[] row = new double[this.aggMatrixRowOI.getListLength(matrix.get(0))];
            for (int i = 0; i < n; ++i) {
                HiveUtils.toDoubleArray(matrix.get(i), this.aggMatrixRowOI, (PrimitiveObjectInspector)this.aggMatrixElemOI, row, false);
                if (myAgg.aggMatrix == null) {
                    myAgg.init(n, row.length);
                }
                for (int j = 0; j < row.length; ++j) {
                    double[] dArray = myAgg.aggMatrix[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + row[j];
                }
            }
        }

        public Object terminatePartial(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            return this.terminate(agg);
        }

        public Object terminate(GenericUDAFEvaluator.AggregationBuffer agg) throws HiveException {
            TransposeAndDotAggregationBuffer myAgg = (TransposeAndDotAggregationBuffer)agg;
            ArrayList<List<DoubleWritable>> result = new ArrayList<List<DoubleWritable>>();
            for (double[] row : myAgg.aggMatrix) {
                result.add(WritableUtils.toWritableList(row));
            }
            return result;
        }

        @GenericUDAFEvaluator.AggregationType(estimable=true)
        static class TransposeAndDotAggregationBuffer
        extends GenericUDAFEvaluator.AbstractAggregationBuffer {
            double[][] aggMatrix;

            TransposeAndDotAggregationBuffer() {
            }

            public int estimate() {
                return this.aggMatrix != null ? this.aggMatrix.length * this.aggMatrix[0].length * 8 : 0;
            }

            public void init(int n, int m) {
                this.aggMatrix = new double[n][m];
            }

            public void reset() {
                if (this.aggMatrix != null) {
                    for (double[] row : this.aggMatrix) {
                        Arrays.fill(row, 0.0);
                    }
                }
            }
        }
    }
}

