/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.text;

import java.text.Normalizer;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.udf.UDFType;

@Description(name="normalize_unicode", value="_FUNC_(string str [, string form]) - Transforms `str` with the specified normalization form. The `form` takes one of NFC (default), NFD, NFKC, or NFKD", extended="SELECT normalize_unicode('\uff8a\uff9d\uff76\uff78\uff76\uff85','NFKC');\n \u30cf\u30f3\u30ab\u30af\u30ab\u30ca\n\nSELECT normalize_unicode('\u3231\u3327\u3326\u2162','NFKC');\n (\u682a)\u30c8\u30f3\u30c9\u30ebIII")
@UDFType(deterministic=true, stateful=false)
public final class NormalizeUnicodeUDF
extends UDF {
    @Nullable
    public String evaluate(@Nullable String str) {
        return this.evaluate(str, null);
    }

    @Nullable
    public String evaluate(@Nullable String str, @Nullable String form) {
        if (str == null) {
            return null;
        }
        if (form == null) {
            return Normalizer.normalize(str, Normalizer.Form.NFC);
        }
        if ("NFC".equals(form)) {
            return Normalizer.normalize(str, Normalizer.Form.NFC);
        }
        if ("NFD".equals(form)) {
            return Normalizer.normalize(str, Normalizer.Form.NFD);
        }
        if ("NFKC".equals(form)) {
            return Normalizer.normalize(str, Normalizer.Form.NFKC);
        }
        if ("NFKD".equals(form)) {
            return Normalizer.normalize(str, Normalizer.Form.NFKD);
        }
        return Normalizer.normalize(str, Normalizer.Form.NFC);
    }
}

