/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.text;

import hivemall.utils.codec.Base91;
import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.io.FastByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import javax.annotation.Nonnull;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;

@Description(name="unbase91", value="_FUNC_(string) - Convert a BASE91 string to a binary", extended="SELECT inflate(unbase91(base91(deflate('aaaaaaaaaaaaaaaabbbbccc'))));\n aaaaaaaaaaaaaaaabbbbccc")
@UDFType(deterministic=true, stateful=false)
public final class Unbase91UDF
extends GenericUDF {
    private StringObjectInspector stringOI;
    @Nonnull
    private transient FastByteArrayOutputStream outputBuf;
    @Nonnull
    private transient BytesWritable result;

    public ObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 1) {
            throw new UDFArgumentException("_FUNC_ takes exactly 1 argument");
        }
        this.stringOI = HiveUtils.asStringOI(argOIs[0]);
        return PrimitiveObjectInspectorFactory.writableBinaryObjectInspector;
    }

    public BytesWritable evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        if (this.outputBuf == null) {
            this.outputBuf = new FastByteArrayOutputStream(4096);
        } else {
            this.outputBuf.reset();
        }
        Object arg0 = arguments[0].get();
        if (arg0 == null) {
            return null;
        }
        Text input = this.stringOI.getPrimitiveWritableObject(arg0);
        byte[] inputBytes = input.getBytes();
        int len = input.getLength();
        try {
            Base91.decode(inputBytes, 0, len, this.outputBuf);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
        if (this.result == null) {
            byte[] outputBytes = this.outputBuf.toByteArray();
            this.result = new BytesWritable(outputBytes);
        } else {
            byte[] outputBytes = this.outputBuf.getInternalArray();
            int outputSize = this.outputBuf.size();
            this.result.set(outputBytes, 0, outputSize);
        }
        return this.result;
    }

    public void close() throws IOException {
        this.outputBuf = null;
        this.result = null;
    }

    public String getDisplayString(String[] children) {
        return "unbase91(" + Arrays.toString(children) + ')';
    }
}

