/*
 * Decompiled with CFR 0.152.
 */
package hivemall.tools.timeseries;

import hivemall.utils.hadoop.HiveUtils;
import hivemall.utils.stats.MovingAverage;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.io.Writable;

@Description(name="moving_avg", value="_FUNC_(NUMBER value, const int windowSize) - Returns moving average of a time series using a given window", extended="SELECT moving_avg(x, 3) FROM (SELECT explode(array(1.0,2.0,3.0,4.0,5.0,6.0,7.0)) as x) series;\n 1.0\n 1.5\n 2.0\n 3.0\n 4.0\n 5.0\n 6.0")
@UDFType(deterministic=false, stateful=true)
public final class MovingAverageUDTF
extends GenericUDTF {
    private PrimitiveObjectInspector valueOI;
    private MovingAverage movingAvg;
    private Writable[] forwardObjs;
    private DoubleWritable result;

    public StructObjectInspector initialize(ObjectInspector[] argOIs) throws UDFArgumentException {
        if (argOIs.length != 2) {
            throw new UDFArgumentException("Two argument is expected for moving_avg(NUMBER value, const int windowSize): " + argOIs.length);
        }
        this.valueOI = HiveUtils.asNumberOI(argOIs[0]);
        int windowSize = HiveUtils.getConstInt(argOIs[1]);
        this.movingAvg = new MovingAverage(windowSize);
        this.result = new DoubleWritable();
        this.forwardObjs = new Writable[]{this.result};
        List<String> fieldNames = Arrays.asList("avg");
        List<ObjectInspector> fieldOIs = Arrays.asList(PrimitiveObjectInspectorFactory.writableDoubleObjectInspector);
        return ObjectInspectorFactory.getStandardStructObjectInspector(fieldNames, fieldOIs);
    }

    public void process(Object[] args) throws HiveException {
        double x = HiveUtils.getDouble(args[0], this.valueOI);
        double avg = this.movingAvg.add(x);
        this.result.set(avg);
        this.forward(this.forwardObjs);
    }

    public void close() throws HiveException {
    }
}

