/*
 * Decompiled with CFR 0.152.
 */
package hivemall.topicmodel;

import hivemall.annotations.VisibleForTesting;
import hivemall.model.FeatureValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public abstract class AbstractProbabilisticTopicModel {
    protected final int _K;
    @Nonnegative
    protected long _D;
    @Nonnull
    protected final List<Map<String, Float>> _miniBatchDocs;
    protected int _miniBatchSize;

    public AbstractProbabilisticTopicModel(@Nonnegative int K) {
        this._K = K;
        this._D = 0L;
        this._miniBatchDocs = new ArrayList<Map<String, Float>>();
    }

    protected static void initMiniBatch(@Nonnull String[][] miniBatch, @Nonnull List<Map<String, Float>> docs) {
        docs.clear();
        FeatureValue probe = new FeatureValue();
        for (String[] e : miniBatch) {
            if (e == null || e.length == 0) continue;
            HashMap<String, Float> doc = new HashMap<String, Float>();
            for (String fv : e) {
                if (fv == null) continue;
                FeatureValue.parseFeatureAsString(fv, probe);
                String label = probe.getFeatureAsString();
                float value = probe.getValueAsFloat();
                doc.put(label, Float.valueOf(value));
            }
            docs.add(doc);
        }
    }

    protected void accumulateDocCount() {
        ++this._D;
    }

    @Nonnegative
    protected long getDocCount() {
        return this._D;
    }

    protected abstract void train(@Nonnull String[][] var1);

    protected abstract float computePerplexity();

    @Nonnull
    protected abstract SortedMap<Float, List<String>> getTopicWords(@Nonnegative int var1);

    @Nonnull
    protected abstract float[] getTopicDistribution(@Nonnull String[] var1);

    @VisibleForTesting
    abstract float getWordScore(@Nonnull String var1, @Nonnegative int var2);

    protected abstract void setWordScore(@Nonnull String var1, @Nonnegative int var2, float var3);
}

