/*
 * Decompiled with CFR 0.152.
 */
package hivemall.topicmodel;

import hivemall.topicmodel.AbstractProbabilisticTopicModel;
import hivemall.topicmodel.OnlineLDAModel;
import hivemall.topicmodel.ProbabilisticTopicModelBaseUDTF;
import hivemall.utils.lang.Primitives;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="train_lda", value="_FUNC_(array<string> words[, const string options]) - Returns a relation consists of <int topic, string word, float score>")
public final class LDAUDTF
extends ProbabilisticTopicModelBaseUDTF {
    public static final double DEFAULT_DELTA = 0.001;
    protected float alpha;
    protected float eta;
    protected long numDocs;
    protected double tau0;
    protected double kappa;
    protected double delta;

    public LDAUDTF() {
        this.alpha = 1.0f / (float)this.topics;
        this.eta = 1.0f / (float)this.topics;
        this.numDocs = 0L;
        this.tau0 = 64.0;
        this.kappa = 0.7;
        this.delta = 0.001;
    }

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("alpha", true, "The hyperparameter for theta [default: 1/k]");
        opts.addOption("eta", true, "The hyperparameter for beta [default: 1/k]");
        opts.addOption("d", "num_docs", true, "The total number of documents [default: auto]");
        opts.addOption("tau", "tau0", true, "The parameter which downweights early iterations [default: 64.0]");
        opts.addOption("kappa", true, "Exponential decay rate (i.e., learning rate) [default: 0.7]");
        opts.addOption("delta", true, "Check convergence in the expectation step [default: 1E-3]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = super.processOptions(argOIs);
        if (cl != null) {
            this.alpha = Primitives.parseFloat(cl.getOptionValue("alpha"), 1.0f / (float)this.topics);
            this.eta = Primitives.parseFloat(cl.getOptionValue("eta"), 1.0f / (float)this.topics);
            this.numDocs = Primitives.parseLong(cl.getOptionValue("num_docs"), 0L);
            this.tau0 = Primitives.parseDouble(cl.getOptionValue("tau0"), 64.0);
            if (this.tau0 <= 0.0) {
                throw new UDFArgumentException("'-tau0' must be positive: " + this.tau0);
            }
            this.kappa = Primitives.parseDouble(cl.getOptionValue("kappa"), 0.7);
            if (this.kappa <= 0.5 || this.kappa > 1.0) {
                throw new UDFArgumentException("'-kappa' must be in (0.5, 1.0]: " + this.kappa);
            }
            this.delta = Primitives.parseDouble(cl.getOptionValue("delta"), 0.001);
        }
        return cl;
    }

    @Override
    protected AbstractProbabilisticTopicModel createModel() {
        return new OnlineLDAModel(this.topics, this.alpha, this.eta, this.numDocs, this.tau0, this.kappa, this.delta);
    }
}

