/*
 * Decompiled with CFR 0.152.
 */
package hivemall.topicmodel;

import hivemall.topicmodel.AbstractProbabilisticTopicModel;
import hivemall.topicmodel.IncrementalPLSAModel;
import hivemall.topicmodel.ProbabilisticTopicModelBaseUDTF;
import hivemall.utils.lang.Primitives;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;

@Description(name="train_plsa", value="_FUNC_(array<string> words[, const string options]) - Returns a relation consists of <int topic, string word, float score>")
public final class PLSAUDTF
extends ProbabilisticTopicModelBaseUDTF {
    public static final float DEFAULT_ALPHA = 0.5f;
    public static final double DEFAULT_DELTA = 0.001;
    protected float alpha = 0.5f;
    protected double delta = 0.001;

    @Override
    protected Options getOptions() {
        Options opts = super.getOptions();
        opts.addOption("alpha", true, "The hyperparameter for P(w|z) update [default: 0.5]");
        opts.addOption("delta", true, "Check convergence in the expectation step [default: 1E-3]");
        return opts;
    }

    @Override
    protected CommandLine processOptions(ObjectInspector[] argOIs) throws UDFArgumentException {
        CommandLine cl = super.processOptions(argOIs);
        if (cl != null) {
            this.alpha = Primitives.parseFloat(cl.getOptionValue("alpha"), 0.5f);
            this.delta = Primitives.parseDouble(cl.getOptionValue("delta"), 0.001);
        }
        return cl;
    }

    @Override
    protected AbstractProbabilisticTopicModel createModel() {
        return new IncrementalPLSAModel(this.topics, this.alpha, this.delta);
    }
}

