/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.codec;

import hivemall.utils.codec.CompressionCodec;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.annotation.Nonnull;

public final class DeflateCodec
extends CompressionCodec {
    private final Deflater compressor;
    private final Inflater decompressor;

    public DeflateCodec() {
        this(true, true);
    }

    public DeflateCodec(boolean compress, boolean decompress) {
        this.compressor = compress ? new Deflater(-1, true) : null;
        this.decompressor = decompress ? new Inflater(true) : null;
    }

    @Override
    public byte[] compress(@Nonnull byte[] in, int off, int len) throws IOException {
        return this.compress(in, off, len, -1);
    }

    @Nonnull
    public byte[] compress(@Nonnull byte[] in, int off, int len, int level) throws IOException {
        int header;
        int compressedSize;
        byte[] compressedData = new byte[len];
        try {
            this.compressor.reset();
            if (level != -1) {
                this.compressor.setLevel(level);
            }
            this.compressor.setInput(in, off, len);
            this.compressor.finish();
            compressedSize = this.compressor.deflate(compressedData);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (compressedSize == 0) {
            compressedData = in;
            compressedSize = len;
            header = 0;
        } else if (compressedSize >= len - 4) {
            compressedData = in;
            compressedSize = len;
            header = 0;
        } else {
            header = len;
        }
        byte[] output = new byte[compressedSize + 4];
        output[0] = (byte)(header >> 24);
        output[1] = (byte)(header >> 16);
        output[2] = (byte)(header >> 8);
        output[3] = (byte)header;
        System.arraycopy(compressedData, 0, output, 4, compressedSize);
        return output;
    }

    @Override
    public byte[] decompress(@Nonnull byte[] in, int off, int len) throws IOException {
        int originalSize = ((in[off] & 0xFF) << 24) + ((in[off + 1] & 0xFF) << 16) + ((in[off + 2] & 0xFF) << 8) + (in[off + 3] & 0xFF);
        if (originalSize == 0) {
            byte[] dest = new byte[len - 4];
            System.arraycopy(in, 4, dest, 0, len - 4);
            return dest;
        }
        byte[] result = new byte[originalSize];
        try {
            this.decompressor.reset();
            this.decompressor.setInput(in, 4, len - 4);
            this.decompressor.inflate(result);
        }
        catch (DataFormatException dfe) {
            throw new IOException(dfe);
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        if (this.compressor != null) {
            this.compressor.end();
        }
        if (this.decompressor != null) {
            this.decompressor.end();
        }
    }
}

