/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import hivemall.utils.lang.Preconditions;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class DoubleRingBuffer
implements Iterable<Double> {
    private final double[] ring;
    private final int capacity;
    private int size;
    private int head;

    public DoubleRingBuffer(int capacity) {
        this.ring = new double[capacity];
        this.capacity = capacity;
        this.size = 0;
        this.head = 0;
    }

    @Nonnull
    public double[] getRing() {
        return this.ring;
    }

    public int capacity() {
        return this.capacity;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean isFull() {
        return this.size == this.capacity;
    }

    public DoubleRingBuffer add(double x) {
        this.ring[this.head] = x;
        this.head = (this.head + 1) % this.capacity;
        if (this.size != this.capacity) {
            ++this.size;
        }
        return this;
    }

    public double head() {
        return this.ring[this.head];
    }

    public void toArray(@Nonnull double[] dst) {
        this.toArray(dst, true);
    }

    public void toArray(@Nonnull double[] dst, boolean fifo) {
        Preconditions.checkArgument(dst.length == this.capacity);
        if (fifo) {
            int curr = this.isFull() ? this.head : 0;
            for (int i = 0; i < this.capacity; ++i) {
                dst[i] = this.ring[curr];
                curr = (curr + 1) % this.capacity;
            }
        } else {
            int i;
            int curr = this.isFull() ? this.head : 0;
            for (i = 1; i <= this.size; ++i) {
                dst[this.size - i] = this.ring[curr];
                curr = (curr + 1) % this.capacity;
            }
            for (i = this.size; i < this.capacity; ++i) {
                dst[i] = 0.0;
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append('{');
        int curr = this.isFull() ? this.head : 0;
        for (int i = 0; i < this.capacity; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.ring[curr]);
            curr = (curr + 1) % this.capacity;
        }
        buf.append('}');
        return buf.toString();
    }

    @Override
    public Iterator<Double> iterator() {
        return new Itor();
    }

    private final class Itor
    implements Iterator<Double> {
        private int curr;
        private int i;

        Itor() {
            this.curr = DoubleRingBuffer.this.isFull() ? DoubleRingBuffer.this.head : 0;
            this.i = 0;
        }

        @Override
        public boolean hasNext() {
            return this.i < DoubleRingBuffer.this.capacity;
        }

        @Override
        public Double next() {
            Double d = DoubleRingBuffer.this.ring[this.curr];
            this.curr = (this.curr + 1) % DoubleRingBuffer.this.capacity;
            ++this.i;
            return d;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

