/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class IndexedSet<E>
extends AbstractSet<E>
implements Externalizable {
    private static final long serialVersionUID = 8775694634056054599L;
    private Map<E, Integer> _map;
    private ArrayList<E> _list;

    public IndexedSet() {
        this(256);
    }

    public IndexedSet(int size) {
        this._map = new HashMap<E, Integer>(size);
        this._list = new ArrayList(size);
    }

    public void ensureSize(int expectedSize) {
        int actualSize = this._list.size();
        if (actualSize < expectedSize) {
            this._list.ensureCapacity(expectedSize);
            int delta = expectedSize - actualSize;
            Object[] ary = new Object[delta];
            List<Object> lst = Arrays.asList(ary);
            this._list.addAll(lst);
        }
    }

    public int indexOf(E e) {
        Integer v = this._map.get(e);
        return v == null ? -1 : v;
    }

    public int addIndexOf(E e) {
        Integer v = this._map.get(e);
        if (v == null) {
            int i = this._list.size();
            this._list.add(e);
            this._map.put(e, i);
            return i;
        }
        return v;
    }

    @Override
    public boolean add(E e) {
        if (this._map.containsKey(e)) {
            return true;
        }
        int i = this._list.size();
        this._list.add(e);
        this._map.put(e, i);
        return false;
    }

    public E get(int index) {
        return this._list.get(index);
    }

    public void set(int index, E value) {
        this._map.put(value, index);
        this._list.set(index, value);
    }

    @Override
    public Iterator<E> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        HashMap<E, Integer> map = new HashMap<E, Integer>(size);
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object e = in.readObject();
            list.add(e);
            map.put(e, i);
        }
        this._map = map;
        this._list = list;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int size = this._list.size();
        out.writeInt(size);
        if (size > 0) {
            for (int i = 0; i < size; ++i) {
                E v = this._list.get(i);
                out.writeObject(v);
            }
        }
    }
}

