/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections.arrays;

import hivemall.utils.collections.arrays.DoubleArray;
import java.util.Arrays;
import javax.annotation.Nonnull;

public final class DenseDoubleArray
implements DoubleArray {
    private static final long serialVersionUID = 4282904528662802088L;
    @Nonnull
    private final double[] array;
    private final int size;

    public DenseDoubleArray(@Nonnull int size) {
        this.array = new double[size];
        this.size = size;
    }

    public DenseDoubleArray(@Nonnull double[] array) {
        this.array = array;
        this.size = array.length;
    }

    @Override
    public double get(int index) {
        return this.array[index];
    }

    @Override
    public double get(int index, double valueIfKeyNotFound) {
        if (index >= this.size) {
            return valueIfKeyNotFound;
        }
        return this.array[index];
    }

    @Override
    public void put(int index, double value) {
        this.array[index] = value;
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public int keyAt(int index) {
        return index;
    }

    @Override
    public double[] toArray() {
        return this.toArray(true);
    }

    @Override
    public double[] toArray(boolean copy) {
        if (copy) {
            return Arrays.copyOf(this.array, this.size);
        }
        return this.array;
    }

    @Override
    public void clear() {
        Arrays.fill(this.array, 0.0);
    }
}

