/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections.arrays;

import hivemall.utils.collections.arrays.IntArray;
import hivemall.utils.function.Consumer;
import java.util.Arrays;
import javax.annotation.Nonnull;

public final class DenseIntArray
implements IntArray {
    private static final long serialVersionUID = -1450212841013810240L;
    @Nonnull
    private final int[] array;
    private final int size;

    public DenseIntArray(@Nonnull int size) {
        this.array = new int[size];
        this.size = size;
    }

    public DenseIntArray(@Nonnull int[] array) {
        this.array = array;
        this.size = array.length;
    }

    @Override
    public int get(int index) {
        return this.array[index];
    }

    @Override
    public int get(int index, int valueIfKeyNotFound) {
        if (index >= this.size) {
            return valueIfKeyNotFound;
        }
        return this.array[index];
    }

    @Override
    public void put(int index, int value) {
        this.array[index] = value;
    }

    @Override
    public void increment(int index, int value) {
        int n = index;
        this.array[n] = this.array[n] + value;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int keyAt(int index) {
        return index;
    }

    @Override
    public int[] toArray() {
        return this.toArray(true);
    }

    @Override
    public int[] toArray(boolean copy) {
        if (copy) {
            return Arrays.copyOf(this.array, this.size);
        }
        return this.array;
    }

    @Override
    public void forEach(@Nonnull Consumer consumer) {
        for (int i = 0; i < this.array.length; ++i) {
            consumer.accept(i, this.array[i]);
        }
    }
}

