/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections.arrays;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import javax.annotation.Nonnull;

public final class DoubleArray3D {
    private static final int DEFAULT_SIZE = 100000;
    private final boolean direct;
    @Nonnull
    private DoubleBuffer buffer;
    private int capacity;
    private int size;
    private int n1;
    private int n2;
    private int n3;
    private int p1;
    private int p2;
    private boolean sanityCheck;

    public DoubleArray3D() {
        this(100000, true);
    }

    public DoubleArray3D(int initSize, boolean direct) {
        this.direct = direct;
        this.buffer = DoubleArray3D.allocate(direct, initSize);
        this.capacity = initSize;
        this.size = -1;
        this.sanityCheck = true;
    }

    public DoubleArray3D(int dim1, int dim2, int dim3) {
        this.direct = true;
        this.capacity = -1;
        this.configure(dim1, dim2, dim3);
        this.sanityCheck = true;
    }

    public void setSanityCheck(boolean enable) {
        this.sanityCheck = enable;
    }

    public void configure(int dim1, int dim2, int dim3) {
        int requiredSize = DoubleArray3D.cardinality(dim1, dim2, dim3);
        if (requiredSize > this.capacity) {
            this.buffer = DoubleArray3D.allocate(this.direct, requiredSize);
            this.capacity = requiredSize;
        }
        this.size = requiredSize;
        this.n1 = dim1;
        this.n2 = dim2;
        this.n3 = dim3;
        this.p1 = this.n2 * this.n3;
        this.p2 = this.n3;
    }

    public void clear() {
        this.buffer.clear();
        this.size = -1;
    }

    public int getSize() {
        return this.size;
    }

    int getCapacity() {
        return this.capacity;
    }

    public double get(int i, int j, int k) {
        int idx = this.idx(i, j, k);
        return this.buffer.get(idx);
    }

    public void set(int i, int j, int k, double val) {
        int idx = this.idx(i, j, k);
        this.buffer.put(idx, val);
    }

    private int idx(int i, int j, int k) {
        if (!this.sanityCheck) {
            return i * this.p1 + j * this.p2 + k;
        }
        if (this.size == -1) {
            throw new IllegalStateException("Double3DArray#configure() is not called");
        }
        if (i >= this.n1 || i < 0) {
            throw new ArrayIndexOutOfBoundsException("Index '" + i + "' out of bounds for 1st dimension of size " + this.n1);
        }
        if (j >= this.n2 || j < 0) {
            throw new ArrayIndexOutOfBoundsException("Index '" + j + "' out of bounds for 2nd dimension of size " + this.n2);
        }
        if (k >= this.n3 || k < 0) {
            throw new ArrayIndexOutOfBoundsException("Index '" + k + "' out of bounds for 3rd dimension of size " + this.n3);
        }
        int idx = i * this.p1 + j * this.p2 + k;
        if (idx >= this.size) {
            throw new IndexOutOfBoundsException("Computed internal index '" + idx + "' exceeds buffer size '" + this.size + "' where i=" + i + ", j=" + j + ", k=" + k);
        }
        return idx;
    }

    private static int cardinality(int dim1, int dim2, int dim3) {
        if (dim1 <= 0 || dim2 <= 0 || dim3 <= 0) {
            throw new IllegalArgumentException("Detected negative dimension size. dim1=" + dim1 + ", dim2=" + dim2 + ", dim3=" + dim3);
        }
        return dim1 * dim2 * dim3;
    }

    @Nonnull
    private static DoubleBuffer allocate(boolean direct, int size) {
        int bytes = size * 8;
        ByteBuffer buf = direct ? ByteBuffer.allocateDirect(bytes) : ByteBuffer.allocate(bytes);
        return buf.asDoubleBuffer();
    }
}

