/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections.lists;

import hivemall.utils.lang.ArrayUtils;
import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class IntArrayList
implements Serializable {
    private static final long serialVersionUID = -2147675120406747488L;
    public static final int DEFAULT_CAPACITY = 12;
    @Nonnull
    private int[] data;
    private int used;

    public IntArrayList() {
        this(12);
    }

    public IntArrayList(int size) {
        this.data = new int[size];
        this.used = 0;
    }

    public IntArrayList(@CheckForNull int[] initValues) {
        this.data = Objects.requireNonNull(initValues);
        this.used = initValues.length;
    }

    @Nonnull
    public IntArrayList add(int value) {
        if (this.used >= this.data.length) {
            this.expand(this.used + 1);
        }
        this.data[this.used++] = value;
        return this;
    }

    @Nonnull
    public IntArrayList add(@Nonnull int[] values) {
        int needs = this.used + values.length;
        if (needs >= this.data.length) {
            this.expand(needs);
        }
        System.arraycopy(values, 0, this.data, this.used, values.length);
        this.used = needs;
        return this;
    }

    private void expand(int minimumCapacity) {
        while (this.data.length < minimumCapacity) {
            int oldLen = this.data.length;
            int newLen = (int)Math.max((long)minimumCapacity, Math.min((long)oldLen * 2L, Integer.MAX_VALUE));
            int[] newArray = new int[newLen];
            System.arraycopy(this.data, 0, newArray, 0, oldLen);
            this.data = newArray;
        }
    }

    public int remove() {
        if (this.used == 0) {
            throw new NoSuchElementException("No elements to remove");
        }
        return this.data[--this.used];
    }

    public int remove(int index) {
        int ret;
        if (index >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.used) {
            ret = this.data[index];
            --this.used;
        } else {
            ret = this.data[index];
            System.arraycopy(this.data, index + 1, this.data, index, this.used - index - 1);
            --this.used;
        }
        return ret;
    }

    public void set(int index, int value) {
        if (index > this.used) {
            throw new IllegalArgumentException("Index " + index + " MUST be less than size() " + this.used);
        }
        if (index == this.used) {
            ++this.used;
        }
        this.data[index] = value;
    }

    public int get(int index) {
        if (index >= this.used) {
            throw new IndexOutOfBoundsException("Index " + index + " out of bounds " + this.used);
        }
        return this.data[index];
    }

    public int fastGet(int index) {
        return this.data[index];
    }

    public int indexOf(int key) {
        return ArrayUtils.indexOf(this.data, key, 0, this.used);
    }

    public boolean contains(int key) {
        return ArrayUtils.indexOf(this.data, key, 0, this.used) != -1;
    }

    public int size() {
        return this.used;
    }

    public boolean isEmpty() {
        return this.used == 0;
    }

    public void clear() {
        this.used = 0;
    }

    @Nonnull
    public int[] toArray() {
        return this.toArray(false);
    }

    @Nonnull
    public int[] toArray(boolean close) {
        int[] newArray = new int[this.used];
        System.arraycopy(this.data, 0, newArray, 0, this.used);
        if (close) {
            this.data = null;
        }
        return newArray;
    }

    public int[] array() {
        return this.data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.used; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
        }
        buf.append(']');
        return buf.toString();
    }
}

