/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections.lists;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public final class LongArrayList
implements Serializable {
    private static final long serialVersionUID = 6928415231676568533L;
    public static final int DEFAULT_CAPACITY = 12;
    @Nonnull
    private long[] data;
    private int used;

    public LongArrayList() {
        this(12);
    }

    public LongArrayList(int size) {
        this.data = new long[size];
        this.used = 0;
    }

    public LongArrayList(@CheckForNull long[] initValues) {
        this.data = Objects.requireNonNull(initValues);
        this.used = initValues.length;
    }

    @Nonnull
    public LongArrayList add(long value) {
        if (this.used >= this.data.length) {
            this.expand(this.used + 1);
        }
        this.data[this.used++] = value;
        return this;
    }

    @Nonnull
    public LongArrayList add(@Nonnull long[] values) {
        int needs = this.used + values.length;
        if (needs >= this.data.length) {
            this.expand(needs);
        }
        System.arraycopy(values, 0, this.data, this.used, values.length);
        this.used = needs;
        return this;
    }

    private void expand(int minimumCapacity) {
        while (this.data.length < minimumCapacity) {
            int oldLen = this.data.length;
            int newLen = (int)Math.max((long)minimumCapacity, Math.min((long)oldLen * 2L, Integer.MAX_VALUE));
            long[] newArray = new long[newLen];
            System.arraycopy(this.data, 0, newArray, 0, oldLen);
            this.data = newArray;
        }
    }

    public long remove() {
        if (this.used == 0) {
            throw new NoSuchElementException("No elements to remove");
        }
        return this.data[--this.used];
    }

    public long remove(int index) {
        long ret;
        if (index >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.used) {
            ret = this.data[index];
            --this.used;
        } else {
            ret = this.data[index];
            System.arraycopy(this.data, index + 1, this.data, index, this.used - index - 1);
            --this.used;
        }
        return ret;
    }

    public void set(int index, long value) {
        if (index > this.used) {
            throw new IllegalArgumentException("Index MUST be less than \"size()\".");
        }
        if (index == this.used) {
            ++this.used;
        }
        this.data[index] = value;
    }

    public long get(int index) {
        if (index >= this.used) {
            throw new IndexOutOfBoundsException();
        }
        return this.data[index];
    }

    public long fastGet(int index) {
        return this.data[index];
    }

    public int size() {
        return this.used;
    }

    public boolean isEmpty() {
        return this.used == 0;
    }

    public void clear() {
        this.used = 0;
    }

    @Nonnull
    public long[] toArray() {
        return this.toArray(false);
    }

    @Nonnull
    public long[] toArray(boolean close) {
        long[] newArray = new long[this.used];
        System.arraycopy(this.data, 0, newArray, 0, this.used);
        if (close) {
            this.data = null;
        }
        return newArray;
    }

    @Nonnull
    public long[] array() {
        return this.data;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        for (int i = 0; i < this.used; ++i) {
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(this.data[i]);
        }
        buf.append(']');
        return buf.toString();
    }
}

