/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections.maps;

import hivemall.utils.lang.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public final class BoundedSortedMap<K, V>
extends TreeMap<K, V> {
    private static final long serialVersionUID = 4580890152997313541L;
    private final int bound;

    public BoundedSortedMap(@Nonnegative int size) {
        this(size, false);
    }

    public BoundedSortedMap(@Nonnegative int size, boolean reverseOrder) {
        super(reverseOrder ? Collections.reverseOrder() : null);
        Preconditions.checkArgument(size > 0, "size must be greater than zero: " + size);
        this.bound = size;
    }

    @Override
    @Nullable
    public V put(@CheckForNull K key, @Nullable V value) {
        V old = super.put(key, value);
        if (this.size() > this.bound) {
            Map.Entry e = this.pollLastEntry();
            if (e == null) {
                return null;
            }
            return e.getValue();
        }
        return old;
    }
}

