/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.collections.sets;

import hivemall.utils.collections.sets.IntSet;
import hivemall.utils.lang.ArrayUtils;
import java.util.Arrays;
import javax.annotation.Nonnull;

public final class IntArraySet
implements IntSet {
    @Nonnull
    private int[] mKeys;
    private int mSize;

    public IntArraySet() {
        this(0);
    }

    public IntArraySet(int initSize) {
        this.mKeys = new int[initSize];
        this.mSize = 0;
    }

    @Override
    public boolean add(int k) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, k);
        if (i >= 0) {
            return false;
        }
        this.mKeys = ArrayUtils.insert(this.mKeys, this.mSize, ~i, k);
        ++this.mSize;
        return true;
    }

    @Override
    public boolean remove(int k) {
        int i = Arrays.binarySearch(this.mKeys, 0, this.mSize, k);
        if (i < 0) {
            return false;
        }
        System.arraycopy(this.mKeys, i + 1, this.mKeys, i, this.mSize - (i + 1));
        --this.mSize;
        return true;
    }

    @Override
    public boolean contains(int k) {
        return Arrays.binarySearch(this.mKeys, 0, this.mSize, k) >= 0;
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public void clear() {
        this.mSize = 0;
    }

    @Override
    public int[] toArray(boolean copy) {
        if (!copy && this.mKeys.length == this.mSize) {
            return this.mKeys;
        }
        return Arrays.copyOf(this.mKeys, this.mSize);
    }
}

