/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.concurrent;

import hivemall.utils.concurrent.NamedThreadFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ExecutorFactory {
    private ExecutorFactory() {
    }

    public static ThreadPoolExecutor newFixedThreadPool(int nThreads, String threadName, boolean daemon) {
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new NamedThreadFactory(threadName, daemon));
    }

    public static Executor newDirectExecutor() {
        return new DirectExecutor();
    }

    static final class DirectExecutor
    implements Executor {
        DirectExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }
    }
}

