/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class NamedThreadFactory
implements ThreadFactory {
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final String namePrefix;
    private boolean daemon = false;
    private int threadPriority = 5;

    public NamedThreadFactory(String threadName) {
        this(threadName, false);
    }

    public NamedThreadFactory(String threadName, boolean daemon) {
        if (threadName == null) {
            throw new IllegalArgumentException();
        }
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = threadName + '-';
        this.daemon = daemon;
    }

    public NamedThreadFactory(String threadName, ThreadGroup threadGroup) {
        if (threadName == null) {
            throw new IllegalArgumentException();
        }
        if (threadGroup == null) {
            throw new IllegalArgumentException();
        }
        this.group = threadGroup;
        this.namePrefix = threadName + '-';
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setPriority(int priority) {
        this.threadPriority = priority;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon() != this.daemon) {
            t.setDaemon(this.daemon);
        }
        if (t.getPriority() != this.threadPriority) {
            t.setPriority(this.threadPriority);
        }
        return t;
    }
}

