/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.datetime;

import java.text.DecimalFormat;

public final class DateTimeFormatter {
    private DateTimeFormatter() {
    }

    public static String formatTime(long t) {
        long sec;
        long min;
        if (t == 0L) {
            return "0ms";
        }
        StringBuilder buf = new StringBuilder();
        long hour = t / 3600000L;
        if (hour > 0L) {
            buf.append(hour + "h ");
            t %= 3600000L;
        }
        if ((min = t / 60000L) > 0L) {
            buf.append(min + "m ");
            t %= 60000L;
        }
        if ((sec = t / 1000L) > 0L) {
            buf.append(sec + "s ");
            t %= 1000L;
        }
        if (t > 0L) {
            buf.append(t + "ms");
        }
        return buf.length() == 0 ? "0ms" : buf.toString();
    }

    public static String formatTime(double timeInMills) {
        long sec;
        long min;
        if (timeInMills == 0.0) {
            return "0ms";
        }
        StringBuilder buf = new StringBuilder();
        long t = (long)timeInMills;
        float diff = (float)(timeInMills - (double)t);
        long hour = t / 3600000L;
        if (hour > 0L) {
            buf.append(hour + "h ");
            t %= 3600000L;
        }
        if ((min = t / 60000L) > 0L) {
            buf.append(min + "m ");
            t %= 60000L;
        }
        if ((sec = t / 1000L) > 0L) {
            buf.append(sec + "s ");
            t %= 1000L;
        }
        if (t > 0L || diff > 0.0f) {
            buf.append(String.format("%.2f", Float.valueOf(diff + (float)t)));
            buf.append("ms");
        }
        return buf.length() == 0 ? "0ms" : buf.toString();
    }

    public static String formatNanoTime(long t) {
        long ms = t / 1000000L;
        return DateTimeFormatter.formatTime(ms);
    }

    public static String formatTimeInSec(long mills) {
        double sec = (double)mills / 1000.0;
        return DateTimeFormatter.formatNumber(sec, false);
    }

    public static String formatTimeInSec(double mills) {
        double sec = mills / 1000.0;
        return DateTimeFormatter.formatNumber(sec, false);
    }

    private static String formatNumber(double number, boolean commaSep) {
        DecimalFormat f = new DecimalFormat(commaSep ? "#,###.###" : "###.###");
        f.setDecimalSeparatorAlwaysShown(false);
        return f.format(number);
    }
}

