/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.geospatial;

import hivemall.utils.math.MathUtils;
import javax.annotation.Nonnegative;

public final class GeoSpatialUtils {
    public static final double MAX_LATITUDE = 85.0511;
    public static final double MIN_LATITUDE = -85.0511;

    private GeoSpatialUtils() {
    }

    public static int lon2tilex(double lon, @Nonnegative int zoom) {
        if (lon < -180.0 || lon > 180.0) {
            throw new IllegalArgumentException("Longitude must be in range [-180,+180]: " + lon);
        }
        return (int)Math.floor((lon + 180.0) / 360.0 * (double)(1 << zoom));
    }

    public static int lat2tiley(double lat, @Nonnegative int zoom) {
        if (lat < -85.0511 || lat > 85.0511) {
            throw new IllegalArgumentException("Latitude must be in range [-85.0511,+85.0511]: " + lat + "\nSee http://wiki.openstreetmap.org/wiki/Slippy_map_tilenames");
        }
        double lat_rad = Math.toRadians(lat);
        int n = 1 << zoom;
        return (int)Math.floor((1.0 - Math.log(Math.tan(lat_rad) + MathUtils.sec(lat_rad)) / Math.PI) / 2.0 * (double)n);
    }

    public static double tilex2lon(int x, @Nonnegative int zoom) {
        return (double)x / Math.pow(2.0, zoom) * 360.0 - 180.0;
    }

    public static double tiley2lat(int y, @Nonnegative int zoom) {
        double n = Math.PI - Math.PI * 2 * (double)y / Math.pow(2.0, zoom);
        return Math.toDegrees(Math.atan(Math.sinh(n)));
    }

    public static long tile(double lat, double lon, @Nonnegative int zoom) {
        int xtile = GeoSpatialUtils.lon2tilex(lon, zoom);
        int ytile = GeoSpatialUtils.lat2tiley(lat, zoom);
        long n = 1L << zoom;
        return (long)xtile + n * (long)ytile;
    }

    public static int tiles(int zoom) {
        return 1 << zoom * 2;
    }

    public static double haversineDistance(double lat1, double lon1, double lat2, double lon2) {
        double R = 6371.0;
        double dLat = Math.toRadians(lat2 - lat1);
        double dLon = Math.toRadians(lon2 - lon1);
        double sinDLat = Math.sin(dLat / 2.0);
        double sinDLon = Math.sin(dLon / 2.0);
        double a = sinDLat * sinDLat + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * sinDLon * sinDLon;
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return R * c;
    }
}

