/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.hadoop;

import hivemall.codehaus.jackson.JsonFactory;
import hivemall.codehaus.jackson.JsonParseException;
import hivemall.codehaus.jackson.JsonParser;
import hivemall.codehaus.jackson.JsonToken;
import hivemall.hcatalog.common.HCatException;
import hivemall.hcatalog.data.schema.HCatFieldSchema;
import hivemall.hcatalog.data.schema.HCatSchema;
import hivemall.hcatalog.data.schema.HCatSchemaUtils;
import hivemall.utils.hadoop.HiveJsonStructReader;
import hivemall.utils.io.FastByteArrayInputStream;
import hivemall.utils.lang.Preconditions;
import java.io.IOException;
import java.nio.charset.CharacterCodingException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BinaryObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DateObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveCharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.HiveVarcharObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.BaseCharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Text;

public final class JsonSerdeUtils {
    @Nonnull
    public static Text serialize(@Nullable Object obj, @Nonnull ObjectInspector oi) throws SerDeException {
        return JsonSerdeUtils.serialize(obj, oi, null);
    }

    @Nonnull
    public static Text serialize(@Nullable Object obj, @Nonnull ObjectInspector oi, @Nullable List<String> columnNames) throws SerDeException {
        StringBuilder sb = new StringBuilder();
        switch (oi.getCategory()) {
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                JsonSerdeUtils.serializeStruct(sb, obj, soi, columnNames);
                break;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                JsonSerdeUtils.serializeList(sb, obj, loi);
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                JsonSerdeUtils.serializeMap(sb, obj, moi);
                break;
            }
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                JsonSerdeUtils.serializePrimitive(sb, obj, poi);
                break;
            }
            default: {
                throw new SerDeException("Unknown type in ObjectInspector: " + oi.getCategory());
            }
        }
        return new Text(sb.toString());
    }

    private static void serializeStruct(@Nonnull StringBuilder sb, @Nullable Object obj, @Nonnull StructObjectInspector soi, @Nullable List<String> columnNames) throws SerDeException {
        if (obj == null) {
            sb.append("null");
        } else {
            List structFields = soi.getAllStructFieldRefs();
            sb.append("{");
            if (columnNames == null) {
                int len = structFields.size();
                for (int i = 0; i < len; ++i) {
                    String colName = ((StructField)structFields.get(i)).getFieldName();
                    if (i > 0) {
                        sb.append(',');
                    }
                    JsonSerdeUtils.appendWithQuotes(sb, colName);
                    sb.append(':');
                    JsonSerdeUtils.buildJSONString(sb, soi.getStructFieldData(obj, (StructField)structFields.get(i)), ((StructField)structFields.get(i)).getFieldObjectInspector());
                }
            } else if (columnNames.size() == structFields.size()) {
                int len = structFields.size();
                for (int i = 0; i < len; ++i) {
                    if (i > 0) {
                        sb.append(',');
                    }
                    String colName = columnNames.get(i);
                    JsonSerdeUtils.appendWithQuotes(sb, colName);
                    sb.append(':');
                    JsonSerdeUtils.buildJSONString(sb, soi.getStructFieldData(obj, (StructField)structFields.get(i)), ((StructField)structFields.get(i)).getFieldObjectInspector());
                }
            } else {
                Collections.sort(columnNames);
                ArrayList<String> found = new ArrayList<String>(columnNames.size());
                int len = structFields.size();
                for (int i = 0; i < len; ++i) {
                    String colName = ((StructField)structFields.get(i)).getFieldName();
                    if (Collections.binarySearch(columnNames, colName) < 0) continue;
                    if (!found.isEmpty()) {
                        sb.append(',');
                    }
                    JsonSerdeUtils.appendWithQuotes(sb, colName);
                    sb.append(':');
                    JsonSerdeUtils.buildJSONString(sb, soi.getStructFieldData(obj, (StructField)structFields.get(i)), ((StructField)structFields.get(i)).getFieldObjectInspector());
                    found.add(colName);
                }
                if (found.size() != columnNames.size()) {
                    ArrayList<String> expected = new ArrayList<String>(columnNames);
                    expected.removeAll(found);
                    throw new SerDeException("Could not find some fields: " + expected);
                }
            }
            sb.append("}");
        }
    }

    @Nonnull
    private static void serializeList(@Nonnull StringBuilder sb, @Nullable Object obj, @Nullable ListObjectInspector loi) throws SerDeException {
        ObjectInspector listElementObjectInspector = loi.getListElementObjectInspector();
        List olist = loi.getList(obj);
        if (olist == null) {
            sb.append("null");
        } else {
            sb.append("[");
            for (int i = 0; i < olist.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                JsonSerdeUtils.buildJSONString(sb, olist.get(i), listElementObjectInspector);
            }
            sb.append("]");
        }
    }

    private static void serializeMap(@Nonnull StringBuilder sb, @Nullable Object obj, @Nonnull MapObjectInspector moi) throws SerDeException {
        ObjectInspector mapKeyObjectInspector = moi.getMapKeyObjectInspector();
        ObjectInspector mapValueObjectInspector = moi.getMapValueObjectInspector();
        Map omap = moi.getMap(obj);
        if (omap == null) {
            sb.append("null");
        } else {
            sb.append("{");
            boolean first = true;
            for (Map.Entry entry : omap.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                Map.Entry e = entry;
                StringBuilder keyBuilder = new StringBuilder();
                JsonSerdeUtils.buildJSONString(keyBuilder, e.getKey(), mapKeyObjectInspector);
                String keyString = keyBuilder.toString().trim();
                if (!keyString.isEmpty() && keyString.charAt(0) != '\"') {
                    JsonSerdeUtils.appendWithQuotes(sb, keyString);
                } else {
                    sb.append(keyString);
                }
                sb.append(':');
                JsonSerdeUtils.buildJSONString(sb, e.getValue(), mapValueObjectInspector);
            }
            sb.append("}");
        }
    }

    private static void serializePrimitive(@Nonnull StringBuilder sb, @Nullable Object obj, @Nullable PrimitiveObjectInspector poi) throws SerDeException {
        if (obj == null) {
            sb.append("null");
        } else {
            switch (poi.getPrimitiveCategory()) {
                case BOOLEAN: {
                    boolean b = ((BooleanObjectInspector)poi).get(obj);
                    sb.append(b ? "true" : "false");
                    break;
                }
                case BYTE: {
                    sb.append(((ByteObjectInspector)poi).get(obj));
                    break;
                }
                case SHORT: {
                    sb.append(((ShortObjectInspector)poi).get(obj));
                    break;
                }
                case INT: {
                    sb.append(((IntObjectInspector)poi).get(obj));
                    break;
                }
                case LONG: {
                    sb.append(((LongObjectInspector)poi).get(obj));
                    break;
                }
                case FLOAT: {
                    sb.append(((FloatObjectInspector)poi).get(obj));
                    break;
                }
                case DOUBLE: {
                    sb.append(((DoubleObjectInspector)poi).get(obj));
                    break;
                }
                case STRING: {
                    String s = SerDeUtils.escapeString((String)((StringObjectInspector)poi).getPrimitiveJavaObject(obj));
                    JsonSerdeUtils.appendWithQuotes(sb, s);
                    break;
                }
                case BINARY: {
                    byte[] b = ((BinaryObjectInspector)poi).getPrimitiveJavaObject(obj);
                    Text txt = new Text();
                    txt.set(b, 0, b.length);
                    JsonSerdeUtils.appendWithQuotes(sb, SerDeUtils.escapeString((String)txt.toString()));
                    break;
                }
                case DATE: {
                    Date d = ((DateObjectInspector)poi).getPrimitiveJavaObject(obj);
                    JsonSerdeUtils.appendWithQuotes(sb, d.toString());
                    break;
                }
                case TIMESTAMP: {
                    Timestamp t = ((TimestampObjectInspector)poi).getPrimitiveJavaObject(obj);
                    JsonSerdeUtils.appendWithQuotes(sb, t.toString());
                    break;
                }
                case DECIMAL: {
                    sb.append(((HiveDecimalObjectInspector)poi).getPrimitiveJavaObject(obj));
                    break;
                }
                case VARCHAR: {
                    String s = SerDeUtils.escapeString((String)((HiveVarcharObjectInspector)poi).getPrimitiveJavaObject(obj).toString());
                    JsonSerdeUtils.appendWithQuotes(sb, s);
                    break;
                }
                case CHAR: {
                    String s = SerDeUtils.escapeString((String)((HiveCharObjectInspector)poi).getPrimitiveJavaObject(obj).toString());
                    JsonSerdeUtils.appendWithQuotes(sb, s);
                    break;
                }
                default: {
                    throw new SerDeException("Unknown primitive type: " + poi.getPrimitiveCategory());
                }
            }
        }
    }

    private static void buildJSONString(@Nonnull StringBuilder sb, @Nullable Object obj, @Nonnull ObjectInspector oi) throws SerDeException {
        switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                JsonSerdeUtils.serializePrimitive(sb, obj, poi);
                break;
            }
            case LIST: {
                ListObjectInspector loi = (ListObjectInspector)oi;
                JsonSerdeUtils.serializeList(sb, obj, loi);
                break;
            }
            case MAP: {
                MapObjectInspector moi = (MapObjectInspector)oi;
                JsonSerdeUtils.serializeMap(sb, obj, moi);
                break;
            }
            case STRUCT: {
                StructObjectInspector soi = (StructObjectInspector)oi;
                JsonSerdeUtils.serializeStruct(sb, obj, soi, null);
                break;
            }
            case UNION: {
                UnionObjectInspector uoi = (UnionObjectInspector)oi;
                if (obj == null) {
                    sb.append("null");
                    break;
                }
                sb.append("{");
                sb.append(uoi.getTag(obj));
                sb.append(':');
                JsonSerdeUtils.buildJSONString(sb, uoi.getField(obj), (ObjectInspector)uoi.getObjectInspectors().get(uoi.getTag(obj)));
                sb.append("}");
                break;
            }
            default: {
                throw new SerDeException("Unknown type in ObjectInspector: " + oi.getCategory());
            }
        }
    }

    @Nonnull
    public static <T> T deserialize(@Nonnull Text t) throws SerDeException {
        return JsonSerdeUtils.deserialize(t, null, null);
    }

    @Nonnull
    public static <T> T deserialize(@Nonnull Text t, @Nonnull TypeInfo columnType) throws SerDeException {
        Object result;
        HiveJsonStructReader reader = new HiveJsonStructReader(columnType);
        reader.setIgnoreUnknownFields(true);
        try {
            result = reader.parseStruct(new FastByteArrayInputStream(t.getBytes(), t.getLength()));
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        return (T)result;
    }

    @Nonnull
    public static <T> T deserialize(@Nonnull Text t, @Nullable List<String> columnNames, @Nullable List<TypeInfo> columnTypes) throws SerDeException {
        Object result;
        try {
            JsonParser p = new JsonFactory().createJsonParser(new FastByteArrayInputStream(t.getBytes(), t.getLength()));
            JsonToken token = p.nextToken();
            result = token == JsonToken.START_OBJECT ? JsonSerdeUtils.parseObject(p, columnNames, columnTypes) : (token == JsonToken.START_ARRAY ? JsonSerdeUtils.parseArray(p, columnTypes) : JsonSerdeUtils.parseValue(p));
        }
        catch (JsonParseException e) {
            throw new SerDeException((Throwable)e);
        }
        catch (IOException e) {
            throw new SerDeException((Throwable)e);
        }
        return (T)result;
    }

    @Nonnull
    private static Object parseObject(@Nonnull JsonParser p, @CheckForNull List<String> columnNames, @CheckForNull List<TypeInfo> columnTypes) throws JsonParseException, IOException, SerDeException {
        JsonToken token;
        HCatSchema schema;
        Preconditions.checkNotNull(columnNames, "columnNames MUST NOT be null in parseObject", SerDeException.class);
        Preconditions.checkNotNull(columnTypes, "columnTypes MUST NOT be null in parseObject", SerDeException.class);
        if (columnNames.size() != columnTypes.size()) {
            throw new SerDeException("Size of columnNames and columnTypes does not match. #columnNames=" + columnNames.size() + ", #columnTypes=" + columnTypes.size());
        }
        TypeInfo rowTypeInfo = TypeInfoFactory.getStructTypeInfo(columnNames, columnTypes);
        try {
            schema = HCatSchemaUtils.getHCatSchema(rowTypeInfo).get(0).getStructSubSchema();
        }
        catch (HCatException e) {
            throw new SerDeException((Throwable)e);
        }
        ArrayList<Object> r = new ArrayList<Object>(Collections.nCopies(columnNames.size(), null));
        while ((token = p.nextToken()) != JsonToken.END_OBJECT && token != null) {
            JsonSerdeUtils.populateRecord(r, token, p, schema);
        }
        if (columnTypes.size() == 1) {
            return r.get(0);
        }
        return r;
    }

    @Nonnull
    private static List<Object> parseArray(@Nonnull JsonParser p, @CheckForNull List<TypeInfo> columnTypes) throws HCatException, IOException, SerDeException {
        Preconditions.checkNotNull(columnTypes, "columnTypes MUST NOT be null", SerDeException.class);
        if (columnTypes.size() != 1) {
            throw new IOException("Expected a single array but go " + columnTypes);
        }
        TypeInfo elemType = columnTypes.get(0);
        HCatSchema schema = HCatSchemaUtils.getHCatSchema(elemType);
        HCatFieldSchema listSchema = schema.get(0);
        HCatFieldSchema elemSchema = listSchema.getArrayElementSchema().get(0);
        ArrayList<Object> arr = new ArrayList<Object>();
        while (p.nextToken() != JsonToken.END_ARRAY) {
            arr.add(JsonSerdeUtils.extractCurrentField(p, elemSchema, true));
        }
        return arr;
    }

    @Nonnull
    private static Object parseValue(@Nonnull JsonParser p) throws JsonParseException, IOException {
        JsonToken t = p.getCurrentToken();
        switch (t) {
            case VALUE_FALSE: {
                return Boolean.FALSE;
            }
            case VALUE_TRUE: {
                return Boolean.TRUE;
            }
            case VALUE_NULL: {
                return null;
            }
            case VALUE_STRING: {
                return p.getText();
            }
            case VALUE_NUMBER_FLOAT: {
                return p.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return p.getIntValue();
            }
        }
        throw new IOException("Unexpected token: " + (Object)((Object)t));
    }

    private static void populateRecord(@Nonnull List<Object> r, @Nonnull JsonToken token, @Nonnull JsonParser p, @Nonnull HCatSchema s) throws IOException {
        if (token != JsonToken.FIELD_NAME) {
            throw new IOException("Field name expected");
        }
        String fieldName = p.getText();
        Integer fpos = s.getPosition(fieldName);
        if (fpos == null) {
            fpos = JsonSerdeUtils.getPositionFromHiveInternalColumnName(fieldName);
            if (fpos == -1) {
                JsonSerdeUtils.skipValue(p);
                return;
            }
            if (!fieldName.equalsIgnoreCase(JsonSerdeUtils.getHiveInternalColumnName(fpos))) {
                throw new IOException("Hive internal column name (" + fieldName + ") and position encoding (" + fpos + ") for the column name are at odds");
            }
        }
        HCatFieldSchema hcatFieldSchema = s.getFields().get(fpos);
        Object currField = JsonSerdeUtils.extractCurrentField(p, hcatFieldSchema, false);
        r.set(fpos, currField);
    }

    @Nullable
    private static Object extractCurrentField(@Nonnull JsonParser p, @Nonnull HCatFieldSchema hcatFieldSchema, boolean isTokenCurrent) throws IOException {
        Cloneable val;
        JsonToken valueToken = isTokenCurrent ? p.getCurrentToken() : p.nextToken();
        switch (hcatFieldSchema.getType()) {
            case INT: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Integer.valueOf(p.getIntValue());
                break;
            }
            case TINYINT: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Byte.valueOf(p.getByteValue());
                break;
            }
            case SMALLINT: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Short.valueOf(p.getShortValue());
                break;
            }
            case BIGINT: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Long.valueOf(p.getLongValue());
                break;
            }
            case BOOLEAN: {
                String bval;
                String string = bval = valueToken == JsonToken.VALUE_NULL ? null : p.getText();
                if (bval != null) {
                    val = Boolean.valueOf(bval);
                    break;
                }
                val = null;
                break;
            }
            case FLOAT: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Float.valueOf(p.getFloatValue());
                break;
            }
            case DOUBLE: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Double.valueOf(p.getDoubleValue());
                break;
            }
            case STRING: {
                val = valueToken == JsonToken.VALUE_NULL ? null : p.getText();
                break;
            }
            case BINARY: {
                String b;
                String string = b = valueToken == JsonToken.VALUE_NULL ? null : p.getText();
                if (b != null) {
                    try {
                        String t = Text.decode((byte[])b.getBytes(), (int)0, (int)b.getBytes().length);
                        return t.getBytes();
                    }
                    catch (CharacterCodingException e) {
                        throw new IOException("Error generating json binary type from object.", e);
                    }
                }
                val = null;
                break;
            }
            case DATE: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Date.valueOf(p.getText());
                break;
            }
            case TIMESTAMP: {
                val = valueToken == JsonToken.VALUE_NULL ? null : Timestamp.valueOf(p.getText());
                break;
            }
            case DECIMAL: {
                val = valueToken == JsonToken.VALUE_NULL ? null : HiveDecimal.create((String)p.getText());
                break;
            }
            case VARCHAR: {
                int vLen = ((BaseCharTypeInfo)hcatFieldSchema.getTypeInfo()).getLength();
                val = valueToken == JsonToken.VALUE_NULL ? null : new HiveVarchar(p.getText(), vLen);
                break;
            }
            case CHAR: {
                int cLen = ((BaseCharTypeInfo)hcatFieldSchema.getTypeInfo()).getLength();
                val = valueToken == JsonToken.VALUE_NULL ? null : new HiveChar(p.getText(), cLen);
                break;
            }
            case ARRAY: {
                if (valueToken == JsonToken.VALUE_NULL) {
                    val = null;
                    break;
                }
                if (valueToken != JsonToken.START_ARRAY) {
                    throw new IOException("Start of Array expected");
                }
                ArrayList<Object> arr = new ArrayList<Object>();
                HCatFieldSchema elemSchema = hcatFieldSchema.getArrayElementSchema().get(0);
                while ((valueToken = p.nextToken()) != JsonToken.END_ARRAY) {
                    arr.add(JsonSerdeUtils.extractCurrentField(p, elemSchema, true));
                }
                val = arr;
                break;
            }
            case MAP: {
                if (valueToken == JsonToken.VALUE_NULL) {
                    val = null;
                    break;
                }
                if (valueToken != JsonToken.START_OBJECT) {
                    throw new IOException("Start of Object expected");
                }
                LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
                HCatFieldSchema valueSchema = hcatFieldSchema.getMapValueSchema().get(0);
                while ((valueToken = p.nextToken()) != JsonToken.END_OBJECT) {
                    Object k = JsonSerdeUtils.getObjectOfCorrespondingPrimitiveType(p.getCurrentName(), hcatFieldSchema.getMapKeyTypeInfo());
                    Object v = JsonSerdeUtils.extractCurrentField(p, valueSchema, false);
                    map.put(k, v);
                }
                val = map;
                break;
            }
            case STRUCT: {
                if (valueToken == JsonToken.VALUE_NULL) {
                    val = null;
                    break;
                }
                if (valueToken != JsonToken.START_OBJECT) {
                    throw new IOException("Start of Object expected");
                }
                HCatSchema subSchema = hcatFieldSchema.getStructSubSchema();
                int sz = subSchema.getFieldNames().size();
                ArrayList<Object> struct = new ArrayList<Object>(Collections.nCopies(sz, null));
                while ((valueToken = p.nextToken()) != JsonToken.END_OBJECT) {
                    JsonSerdeUtils.populateRecord(struct, valueToken, p, subSchema);
                }
                val = struct;
                break;
            }
            default: {
                throw new IOException("Unknown type found: " + (Object)((Object)hcatFieldSchema.getType()));
            }
        }
        return val;
    }

    @Nonnull
    private static Object getObjectOfCorrespondingPrimitiveType(String s, PrimitiveTypeInfo mapKeyType) throws IOException {
        switch (HCatFieldSchema.Type.getPrimitiveHType(mapKeyType)) {
            case INT: {
                return Integer.valueOf(s);
            }
            case TINYINT: {
                return Byte.valueOf(s);
            }
            case SMALLINT: {
                return Short.valueOf(s);
            }
            case BIGINT: {
                return Long.valueOf(s);
            }
            case BOOLEAN: {
                return s.equalsIgnoreCase("true");
            }
            case FLOAT: {
                return Float.valueOf(s);
            }
            case DOUBLE: {
                return Double.valueOf(s);
            }
            case STRING: {
                return s;
            }
            case BINARY: {
                try {
                    String t = Text.decode((byte[])s.getBytes(), (int)0, (int)s.getBytes().length);
                    return t.getBytes();
                }
                catch (CharacterCodingException e) {
                    throw new IOException("Error generating json binary type from object.", e);
                }
            }
            case DATE: {
                return Date.valueOf(s);
            }
            case TIMESTAMP: {
                return Timestamp.valueOf(s);
            }
            case DECIMAL: {
                return HiveDecimal.create((String)s);
            }
            case VARCHAR: {
                return new HiveVarchar(s, ((BaseCharTypeInfo)mapKeyType).getLength());
            }
            case CHAR: {
                return new HiveChar(s, ((BaseCharTypeInfo)mapKeyType).getLength());
            }
        }
        throw new IOException("Could not convert from string to map type " + mapKeyType.getTypeName());
    }

    private static int getPositionFromHiveInternalColumnName(String internalName) {
        Pattern internalPattern = Pattern.compile("_col([0-9]+)");
        Matcher m = internalPattern.matcher(internalName);
        if (!m.matches()) {
            return -1;
        }
        return Integer.parseInt(m.group(1));
    }

    private static void skipValue(@Nonnull JsonParser p) throws JsonParseException, IOException {
        JsonToken valueToken = p.nextToken();
        if (valueToken == JsonToken.START_ARRAY || valueToken == JsonToken.START_OBJECT) {
            p.skipChildren();
        }
    }

    @Nonnull
    private static String getHiveInternalColumnName(int fpos) {
        return HiveConf.getColumnInternalName((int)fpos);
    }

    @Nonnull
    private static StringBuilder appendWithQuotes(@Nonnull StringBuilder sb, @Nonnull String value) {
        return sb.append('\"').append(value).append('\"');
    }
}

