/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.hadoop;

import hivemall.utils.io.FastByteArrayInputStream;
import hivemall.utils.io.FastByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.roaringbitmap.RoaringBitmap;

public final class SerdeUtils {
    @Nonnull
    public static byte[] serializeRoaring(@Nonnull RoaringBitmap r) {
        r.runOptimize();
        byte[] buf = new byte[r.serializedSizeInBytes()];
        try {
            r.serialize(new DataOutputStream(new FastByteArrayOutputStream(buf)));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to serialize RoaringBitmap", e);
        }
        return buf;
    }

    @Nonnull
    public static RoaringBitmap deserializeRoaring(@CheckForNull byte[] b) {
        RoaringBitmap bitmap = new RoaringBitmap();
        try {
            bitmap.deserialize(new DataInputStream(new FastByteArrayInputStream(Objects.requireNonNull(b))));
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize RoaringBitmap", e);
        }
        return bitmap;
    }
}

