/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.hadoop;

import hivemall.utils.lang.Preconditions;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;

public final class WritableUtils {
    private WritableUtils() {
    }

    public static IntWritable val(int v) {
        return new IntWritable(v);
    }

    public static LongWritable val(long v) {
        return new LongWritable(v);
    }

    public static FloatWritable val(float v) {
        return new FloatWritable(v);
    }

    public static DoubleWritable val(double v) {
        return new DoubleWritable(v);
    }

    public static BooleanWritable val(boolean v) {
        return new BooleanWritable(v);
    }

    @Nonnull
    public static List<LongWritable> newLongList(int size) {
        ArrayList<LongWritable> list = new ArrayList<LongWritable>(size);
        for (int i = 0; i < size; ++i) {
            list.add(new LongWritable(0L));
        }
        return list;
    }

    @Nonnull
    public static List<DoubleWritable> newDoubleList(int size) {
        return WritableUtils.newDoubleList(size, 0.0);
    }

    @Nonnull
    public static List<FloatWritable> newFloatList(int size) {
        return WritableUtils.newFloatList(size, 0.0f);
    }

    @Nonnull
    public static List<FloatWritable> newFloatList(int size, float defaultValue) {
        ArrayList<FloatWritable> list = new ArrayList<FloatWritable>(size);
        for (int i = 0; i < size; ++i) {
            list.add(new FloatWritable(defaultValue));
        }
        return list;
    }

    @Nonnull
    public static List<DoubleWritable> newDoubleList(int size, double defaultValue) {
        ArrayList<DoubleWritable> list = new ArrayList<DoubleWritable>(size);
        for (int i = 0; i < size; ++i) {
            list.add(new DoubleWritable(defaultValue));
        }
        return list;
    }

    @Nonnull
    public static List<IntWritable> toWritableList(@Nonnull int[] src) {
        ArrayList<IntWritable> list = new ArrayList<IntWritable>(src.length);
        for (int i = 0; i < src.length; ++i) {
            list.add(new IntWritable(src[i]));
        }
        return list;
    }

    @Nonnull
    public static List<LongWritable> toWritableList(@Nonnull long[] src) {
        ArrayList<LongWritable> list = new ArrayList<LongWritable>(src.length);
        for (int i = 0; i < src.length; ++i) {
            list.add(new LongWritable(src[i]));
        }
        return list;
    }

    @Nonnull
    public static List<FloatWritable> toWritableList(@Nonnull float[] src) {
        ArrayList<FloatWritable> list = new ArrayList<FloatWritable>(src.length);
        for (int i = 0; i < src.length; ++i) {
            list.add(new FloatWritable(src[i]));
        }
        return list;
    }

    @Nonnull
    public static List<DoubleWritable> toWritableList(@Nonnull double[] src) {
        ArrayList<DoubleWritable> list = new ArrayList<DoubleWritable>(src.length);
        for (int i = 0; i < src.length; ++i) {
            list.add(new DoubleWritable(src[i]));
        }
        return list;
    }

    @Nonnull
    public static List<FloatWritable> toWritableList(@Nonnull float[] src, @Nullable List<FloatWritable> list) throws UDFArgumentException {
        if (list == null) {
            return WritableUtils.toWritableList(src);
        }
        Preconditions.checkArgument(src.length == list.size(), UDFArgumentException.class);
        for (int i = 0; i < src.length; ++i) {
            list.set(i, new FloatWritable(src[i]));
        }
        return list;
    }

    @Nonnull
    public static List<DoubleWritable> toWritableList(@Nonnull double[] src, @Nullable List<DoubleWritable> list) throws UDFArgumentException {
        if (list == null) {
            return WritableUtils.toWritableList(src);
        }
        Preconditions.checkArgument(src.length == list.size(), UDFArgumentException.class);
        for (int i = 0; i < src.length; ++i) {
            list.set(i, new DoubleWritable(src[i]));
        }
        return list;
    }

    @Nonnull
    public static void setValues(@Nonnull float[] src, @Nonnull List<FloatWritable> list) throws UDFArgumentException {
        Preconditions.checkArgument(src.length == list.size(), UDFArgumentException.class);
        for (int i = 0; i < src.length; ++i) {
            list.set(i, new FloatWritable(src[i]));
        }
    }

    public static Text val(String v) {
        return new Text(v);
    }

    public static List<Text> val(String ... v) {
        ArrayList<Text> list = new ArrayList<Text>(v.length);
        for (int i = 0; i < v.length; ++i) {
            String vi = v[i];
            Text ti = vi == null ? null : new Text(vi);
            list.add(ti);
        }
        return list;
    }

    public static Writable toWritable(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Writable) {
            return (Writable)object;
        }
        if (object instanceof String) {
            return new Text((String)object);
        }
        if (object instanceof Long) {
            return new VLongWritable(((Long)object).longValue());
        }
        if (object instanceof Integer) {
            return new VIntWritable(((Integer)object).intValue());
        }
        if (object instanceof Byte) {
            return new ByteWritable(((Byte)object).byteValue());
        }
        if (object instanceof Double) {
            return new DoubleWritable(((Double)object).doubleValue());
        }
        if (object instanceof Float) {
            return new FloatWritable(((Float)object).floatValue());
        }
        if (object instanceof Boolean) {
            return new BooleanWritable(((Boolean)object).booleanValue());
        }
        if (object instanceof byte[]) {
            return new BytesWritable((byte[])object);
        }
        return new BytesWritable(object.toString().getBytes());
    }

    @Nonnull
    public static Writable copyToWritable(@Nonnull Object obj, @CheckForNull PrimitiveObjectInspector oi) {
        Preconditions.checkNotNull(oi);
        Object ret = ObjectInspectorUtils.copyToStandardObject((Object)obj, (ObjectInspector)oi, (ObjectInspectorUtils.ObjectInspectorCopyOption)ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
        return (Writable)ret;
    }
}

