/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.hashing;

public final class HashUtils {
    private HashUtils() {
    }

    public static int jenkins32(int k) {
        k = k + 2127912214 + (k << 12);
        k = k ^ 0xC761C23C ^ k >> 19;
        k = k + 374761393 + (k << 5);
        k = k + -744332180 ^ k << 9;
        k = k + -42973499 + (k << 3);
        k = k ^ 0xB55A4F09 ^ k >> 16;
        return k;
    }

    public static int murmurHash3(int k) {
        k ^= k >>> 16;
        k *= -2048144789;
        k ^= k >>> 13;
        k *= -1028477387;
        k ^= k >>> 16;
        return k;
    }

    public static int fnv1a(int k) {
        int hash = -2128831035;
        for (int i = 0; i < 4; ++i) {
            hash ^= k << i * 8;
            hash *= 16777619;
        }
        return hash;
    }

    public static int hash32shift(int k) {
        k = ~k + (k << 15);
        k ^= k >>> 12;
        k += k << 2;
        k ^= k >>> 4;
        k *= 2057;
        k ^= k >>> 16;
        return k;
    }

    public static int hash32shiftmult(int k) {
        k = k ^ 0x3D ^ k >>> 16;
        k += k << 3;
        k ^= k >>> 4;
        k *= 668265261;
        k ^= k >>> 15;
        return k;
    }

    public static int hash7shifts(int k) {
        k -= k << 6;
        k ^= k >> 17;
        k -= k << 9;
        k ^= k << 4;
        k -= k << 3;
        k ^= k << 10;
        k ^= k >> 15;
        return k;
    }
}

