/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import hivemall.utils.codec.Base91;
import hivemall.utils.io.FastByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Base91InputStream
extends FilterInputStream {
    private static final int INPUT_BUFFER_SIZE = 2048;
    private byte[] inputBuffer = new byte[2048];
    private FastByteArrayOutputStream outputBuffer;
    @Nonnull
    private final Base91.Base91Buf decodingBuf;
    @Nullable
    private byte[] output;
    private int outputPos;
    private int outputLen;
    private boolean eof;

    public Base91InputStream(@Nonnull InputStream in) {
        super(in);
        int outputBufferSize = Math.round(1791.9329f);
        this.outputBuffer = new FastByteArrayOutputStream(outputBufferSize);
        this.decodingBuf = new Base91.Base91Buf();
        this.output = null;
        this.outputPos = 0;
        this.outputLen = 0;
        this.eof = false;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int available() {
        return this.eof ? 0 : 1;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("Skip is not supported");
    }

    @Override
    public int read() throws IOException {
        if (this.outputPos >= this.outputLen && !this.refill() && !this.decodingBuf.isEmpty()) {
            return Base91.decodeEnd(this.decodingBuf);
        }
        if (this.outputPos >= this.outputLen) {
            return -1;
        }
        return this.output[this.outputPos++] & 0xFF;
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (this.outputPos >= this.outputLen && !this.refill() && !this.decodingBuf.isEmpty()) {
            byte last;
            b[off] = last = Base91.decodeEnd(this.decodingBuf);
            return 1;
        }
        if (this.outputPos >= this.outputLen) {
            return -1;
        }
        int bytes = Math.min(len, this.outputLen - this.outputPos);
        System.arraycopy(this.output, this.outputPos, b, off, bytes);
        this.outputPos += bytes;
        return bytes;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
        this.inputBuffer = null;
        this.outputBuffer = null;
        this.output = null;
    }

    private boolean refill() throws IOException {
        if (this.eof) {
            return false;
        }
        int bytesRead = this.in.read(this.inputBuffer);
        if (bytesRead == -1) {
            this.eof = true;
            this.output = null;
            return false;
        }
        this.outputBuffer.reset();
        Base91.decode(this.inputBuffer, 0, bytesRead, this.outputBuffer, this.decodingBuf);
        this.output = this.outputBuffer.getInternalArray();
        this.outputPos = 0;
        this.outputLen = this.outputBuffer.size();
        return true;
    }
}

