/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import hivemall.utils.codec.Base91;
import hivemall.utils.io.FinishableOutputStreamAdapter;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public final class Base91OutputStream
extends FinishableOutputStreamAdapter {
    private static final int INPUT_BUFFER_SIZE = 2048;
    private byte[] inputBuffer = new byte[2048];
    private int inputPos = 0;
    @Nonnull
    private final Base91.Base91Buf encodingBuf = new Base91.Base91Buf();

    public Base91OutputStream(@Nonnull OutputStream out) {
        super(out);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.inputPos >= this.inputBuffer.length) {
            this.flushBuffer();
        }
        this.inputBuffer[this.inputPos++] = (byte)b;
    }

    @Override
    public void write(@Nonnull byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(@Nonnull byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void close() throws IOException {
        IOException thrown;
        block5: {
            thrown = null;
            try {
                this.flushBuffer();
            }
            catch (IOException e) {
                thrown = e;
            }
            try {
                this._out.flush();
                this._out.close();
            }
            catch (IOException e) {
                if (thrown == null) break block5;
                thrown = e;
            }
        }
        this.inputBuffer = null;
        if (thrown != null) {
            throw thrown;
        }
    }

    private void flushBuffer() throws IOException {
        if (this.inputPos > 0) {
            this.internalWrite(this.inputBuffer, 0, this.inputPos);
            this.inputPos = 0;
        }
    }

    private void internalWrite(@Nonnull byte[] input, int offset, int length) throws IOException {
        Base91.encode(input, offset, length, this._out, this.encodingBuf);
    }

    @Override
    public void finish() throws IOException {
        this.flushBuffer();
        Base91.encodeEnd(this._out, this.encodingBuf);
        this._out.flush();
    }
}

