/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import hivemall.utils.io.DeflaterOutputStream;
import hivemall.utils.io.FinishableOutputStream;
import hivemall.utils.io.FinishableOutputStreamAdapter;
import hivemall.utils.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;
import org.tukaani.xz.FinishableWrapperOutputStream;
import org.tukaani.xz.LZMA2InputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZInputStream;
import org.tukaani.xz.XZOutputStream;

public final class CompressionStreamFactory {
    public static final int DEFAULT_COMPRESSION_LEVEL = -1;

    private CompressionStreamFactory() {
    }

    public static InputStream createInputStream(@Nonnull InputStream in, @Nonnull CompressionAlgorithm algo) {
        return CompressionStreamFactory.createInputStream(in, algo, -1);
    }

    @Nonnull
    public static InputStream createInputStream(@Nonnull InputStream in, @Nonnull CompressionAlgorithm algo, int level) {
        switch (algo) {
            case deflate: {
                return new InflaterInputStream(in);
            }
            case xz: {
                try {
                    return new XZInputStream(in);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to decode by XZ", e);
                }
            }
            case lzma2: {
                int dictSize;
                if (level == -1) {
                    dictSize = 0x800000;
                } else {
                    LZMA2Options options;
                    try {
                        options = new LZMA2Options(level);
                    }
                    catch (UnsupportedOptionsException e) {
                        throw new IllegalStateException("LZMA2Option configuration failed", e);
                    }
                    dictSize = options.getDictSize();
                }
                return new LZMA2InputStream(in, dictSize);
            }
        }
        throw new UnsupportedOperationException("Unsupported compression algorithm: " + (Object)((Object)algo));
    }

    @Nonnull
    public static FinishableOutputStream createOutputStream(@Nonnull OutputStream out, @Nonnull CompressionAlgorithm algo) {
        return CompressionStreamFactory.createOutputStream(out, algo, -1);
    }

    @Nonnull
    public static FinishableOutputStream createOutputStream(final @Nonnull OutputStream out, @Nonnull CompressionAlgorithm algo, int level) {
        switch (algo) {
            case deflate: {
                java.util.zip.DeflaterOutputStream deflateOut;
                if (level == -1) {
                    deflateOut = new java.util.zip.DeflaterOutputStream(out);
                } else {
                    Deflater d = new Deflater(level);
                    deflateOut = new DeflaterOutputStream(out, d);
                }
                return new FinishableOutputStreamAdapter(deflateOut){

                    @Override
                    public void finish() throws IOException {
                        deflateOut.finish();
                        deflateOut.flush();
                        IOUtils.finishStream(out);
                    }
                };
            }
            case xz: {
                XZOutputStream xz;
                LZMA2Options options;
                if (level == -1) {
                    level = 6;
                }
                try {
                    options = new LZMA2Options(level);
                }
                catch (UnsupportedOptionsException e) {
                    throw new IllegalStateException("LZMA2Option configuration failed", e);
                }
                try {
                    xz = new XZOutputStream(out, options);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to encode by XZ", e);
                }
                return new FinishableOutputStreamAdapter(xz){

                    @Override
                    public void finish() throws IOException {
                        xz.finish();
                        IOUtils.finishStream(out);
                    }
                };
            }
            case lzma2: {
                LZMA2Options options;
                if (level == -1) {
                    level = 6;
                }
                try {
                    options = new LZMA2Options(level);
                }
                catch (UnsupportedOptionsException e) {
                    throw new IllegalStateException("LZMA2Option configuration failed", e);
                }
                FinishableWrapperOutputStream wrapped = new FinishableWrapperOutputStream(out);
                final org.tukaani.xz.FinishableOutputStream lzma2 = options.getOutputStream(wrapped);
                return new FinishableOutputStreamAdapter(lzma2){

                    @Override
                    public void finish() throws IOException {
                        lzma2.finish();
                        IOUtils.finishStream(out);
                    }
                };
            }
        }
        throw new UnsupportedOperationException("Unsupported compression algorithm: " + (Object)((Object)algo));
    }

    public static enum CompressionAlgorithm {
        deflate,
        xz,
        lzma2;

    }
}

