/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import hivemall.utils.io.LimitedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class HttpUtils {
    private HttpUtils() {
    }

    @Nonnull
    public static HttpURLConnection getHttpURLConnection(@Nonnull String urlStr) throws IllegalArgumentException, IOException {
        if (!urlStr.startsWith("http://") && !urlStr.startsWith("https://")) {
            throw new IllegalArgumentException("Unexpected url: " + urlStr);
        }
        URL url = new URL(urlStr);
        URLConnection conn = url.openConnection();
        return (HttpURLConnection)conn;
    }

    @Nonnull
    public static InputStream getLimitedInputStream(@Nonnull HttpURLConnection conn, @Nonnegative long size) throws IOException {
        InputStream is = conn.getInputStream();
        return new LimitedInputStream(is, size);
    }
}

