/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import hivemall.utils.lang.Preconditions;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnegative;

public class LimitedInputStream
extends FilterInputStream {
    protected final long max;
    protected long pos = 0L;

    public LimitedInputStream(@CheckForNull InputStream in, @Nonnegative long maxSize) {
        super(in);
        Preconditions.checkNotNull(in, "Base input stream must not be null");
        this.max = maxSize;
    }

    protected void raiseError() throws IOException {
        throw new IOException("Exceeded maximum size of input stream: limit = " + this.max + " bytes, but pos = " + this.pos);
    }

    private void proceed(@Nonnegative long bytes) throws IOException {
        this.pos += bytes;
        if (this.pos > this.max) {
            this.raiseError();
        }
    }

    @Override
    public int read() throws IOException {
        int res = super.read();
        if (res != -1) {
            this.proceed(1L);
        }
        return res;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int res = super.read(b, off, len);
        if (res > 0) {
            this.proceed(res);
        }
        return res;
    }

    @Override
    public long skip(long n) throws IOException {
        long res = super.skip(n);
        if (res > 0L) {
            this.proceed(res);
        }
        return res;
    }
}

