/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.io;

import hivemall.utils.io.NIOUtils;
import hivemall.utils.io.Segments;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NioSegment
implements Segments {
    @Nonnull
    private final File file;
    @Nonnull
    private final RandomAccessFile raf;
    @Nonnull
    protected final FileChannel channel;

    public NioSegment(@Nonnull File file) {
        this(file, false);
    }

    public NioSegment(@Nonnull File file, boolean readOnly) {
        RandomAccessFile raf;
        this.file = file;
        try {
            raf = new RandomAccessFile(file, readOnly ? "r" : "rw");
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("File not found: " + file.getAbsolutePath(), e);
        }
        this.raf = raf;
        this.channel = raf.getChannel();
    }

    @Override
    public final File getFile() {
        return this.file;
    }

    @Override
    public int read(long filePos, @Nonnull ByteBuffer buf) throws IOException {
        return NIOUtils.read(this.channel, buf, filePos);
    }

    @Override
    public int write(long filePos, @Nonnull ByteBuffer buf) throws IOException {
        return NIOUtils.writeFully(this.channel, buf, filePos);
    }

    @Override
    public final void close() throws IOException {
        this.close(false);
    }

    @Override
    public final void close(boolean deleteFile) throws IOException {
        try {
            this.channel.close();
            this.raf.close();
        }
        finally {
            if (deleteFile && this.file.exists()) {
                this.file.delete();
            }
        }
    }

    @Override
    public final void flush() throws IOException {
        this.channel.force(true);
    }
}

