/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import javax.annotation.Nonnull;

public final class ExceptionUtils {
    public static final int TRACE_CAUSE_DEPTH = 5;

    private ExceptionUtils() {
    }

    @Nonnull
    public static String prettyPrintStackTrace(@Nonnull Throwable throwable) {
        return ExceptionUtils.prettyPrintStackTrace(throwable, 5);
    }

    @Nonnull
    public static String prettyPrintStackTrace(@Nonnull Throwable throwable, int traceDepth) {
        StringBuilder out = new StringBuilder(512);
        out.append(ExceptionUtils.getMessage(throwable));
        out.append("\n\n---- Debugging information ----");
        int tracedepth = throwable instanceof RuntimeException || throwable instanceof Error ? -1 : traceDepth;
        String captured = ExceptionUtils.captureThrownWithStrackTrace(throwable, "trace-exception", tracedepth);
        out.append(captured);
        Throwable cause = throwable.getCause();
        if (cause != null) {
            Throwable rootCause = ExceptionUtils.getRootCause(cause);
            captured = ExceptionUtils.captureThrownWithStrackTrace(rootCause, "trace-cause", 5);
            out.append(captured);
        }
        out.append("\n------------------------------- \n");
        return out.toString();
    }

    @Nonnull
    private static String captureThrownWithStrackTrace(@Nonnull Throwable throwable, String label, int traceDepth) {
        int at;
        assert (traceDepth >= 1 || traceDepth == -1);
        StringBuilder out = new StringBuilder(255);
        String clazz = throwable.getClass().getName();
        out.append(String.format("\n%-20s: %s \n", "* " + label, clazz));
        StackTraceElement[] st = throwable.getStackTrace();
        int limit = traceDepth == -1 ? st.length - 1 : traceDepth;
        for (at = 0; at < st.length; ++at) {
            if (at >= limit) {
                out.append("\t...\n");
                break;
            }
            out.append("\tat " + st[at] + '\n');
        }
        if (st.length == 0) {
            out.append("\t no stack traces...");
        } else if (at != st.length - 1) {
            out.append("\tat " + st[st.length - 1]);
        }
        String errmsg = throwable.getMessage();
        if (errmsg != null) {
            out.append(String.format("\n%-20s: \n", "* " + label + "-error-msg"));
            String[] line = errmsg.split("\n");
            int maxlines = Math.min(line.length, Math.max(1, 3));
            for (int i = 0; i < maxlines; ++i) {
                out.append('\t');
                out.append(line[i]);
                if (i == maxlines - 1) continue;
                out.append('\n');
            }
        }
        return out.toString();
    }

    @Nonnull
    public static String getMessage(@Nonnull Throwable throwable) {
        String errMsg = throwable.getMessage();
        String clazz = throwable.getClass().getName();
        return errMsg != null ? clazz + ": " + errMsg : clazz;
    }

    @Nonnull
    private static Throwable getRootCause(@Nonnull Throwable throwable) {
        Throwable parent;
        Throwable top = throwable;
        while (top != null && (parent = top.getCause()) != null) {
            top = parent;
        }
        return top;
    }
}

