/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class Identifier<T>
implements Serializable {
    private static final long serialVersionUID = 7949630590734361716L;
    private final Map<T, Integer> counts = new HashMap<T, Integer>(512);
    private int sequence;

    public Identifier() {
        this(0);
    }

    public Identifier(int initSeq) {
        this.sequence = initSeq;
    }

    public int valueOf(@Nonnull T key) {
        Integer count = this.counts.get(key);
        if (count == null) {
            int id = this.sequence++;
            this.counts.put(key, id);
            return id;
        }
        return count;
    }

    public void put(@Nonnull T key) {
        Integer count = this.counts.get(key);
        if (count != null) {
            return;
        }
        int id = this.sequence++;
        this.counts.put(key, id);
    }

    public Map<T, Integer> getMap() {
        return this.counts;
    }

    public int size() {
        return this.sequence;
    }
}

