/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class LongCounter<E>
implements Serializable {
    private static final long serialVersionUID = 7949630590734361716L;
    private final Map<E, Long> counts;

    public LongCounter() {
        this.counts = new HashMap<E, Long>();
    }

    public LongCounter(@Nonnull Map<E, Long> counts) {
        this.counts = counts;
    }

    public Map<E, Long> getMap() {
        return this.counts;
    }

    public long increment(E key) {
        return this.increment(key, 1L);
    }

    public long increment(E key, long amount) {
        Long count = this.counts.get(key);
        if (count == null) {
            this.counts.put(key, amount);
            return 0L;
        }
        long old = count;
        this.counts.put(key, old + amount);
        return old;
    }

    public long getCount(E key) {
        Long count = this.counts.get(key);
        if (count == null) {
            return 0L;
        }
        return count;
    }

    public void addAll(Map<E, Long> counter) {
        if (counter == null) {
            return;
        }
        for (Map.Entry<E, Long> e : counter.entrySet()) {
            this.increment(e.getKey(), e.getValue());
        }
    }

    public void addAll(LongCounter<E> counter) {
        if (counter == null) {
            return;
        }
        for (Map.Entry<E, Long> e : counter.entrySet()) {
            this.increment(e.getKey(), e.getValue());
        }
    }

    public Set<Map.Entry<E, Long>> entrySet() {
        return this.counts.entrySet();
    }

    @Nullable
    public E whichMax() {
        E maxKey = null;
        long maxValue = Long.MIN_VALUE;
        for (Map.Entry<E, Long> e : this.counts.entrySet()) {
            long v = e.getValue();
            if (v < maxValue) continue;
            maxValue = v;
            maxKey = e.getKey();
        }
        return maxKey;
    }

    @Nullable
    public E whichMin() {
        E minKey = null;
        long minValue = Long.MAX_VALUE;
        for (Map.Entry<E, Long> e : this.counts.entrySet()) {
            long v = e.getValue();
            if (v > minValue) continue;
            minValue = v;
            minKey = e.getKey();
        }
        return minKey;
    }

    public int size() {
        return this.counts.size();
    }
}

