/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import hivemall.utils.io.Base91InputStream;
import hivemall.utils.io.Base91OutputStream;
import hivemall.utils.io.CompressionStreamFactory;
import hivemall.utils.io.FastByteArrayInputStream;
import hivemall.utils.io.FastByteArrayOutputStream;
import hivemall.utils.io.FastMultiByteArrayOutputStream;
import hivemall.utils.io.FinishableOutputStream;
import hivemall.utils.io.IOUtils;
import java.io.Closeable;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnull;

public final class ObjectUtils {
    private ObjectUtils() {
    }

    public static byte[] toBytes(@Nonnull Object obj) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        ObjectUtils.toStream(obj, (OutputStream)bos);
        return bos.toByteArray();
    }

    public static byte[] toBytes(@Nonnull Externalizable obj) throws IOException {
        FastByteArrayOutputStream bos = new FastByteArrayOutputStream();
        ObjectUtils.toStream(obj, (OutputStream)bos);
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toCompressedBytes(@Nonnull Object obj) throws IOException {
        FastMultiByteArrayOutputStream bos = new FastMultiByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(bos);
        try {
            ObjectUtils.toStream(obj, (OutputStream)dos);
            dos.finish();
            dos.flush();
            byte[] byArray = bos.toByteArray_clear();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)dos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toCompressedBytes(@Nonnull Externalizable obj) throws IOException {
        FastMultiByteArrayOutputStream bos = new FastMultiByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream(bos);
        try {
            ObjectUtils.toStream(obj, (OutputStream)dos);
            dos.finish();
            dos.flush();
            byte[] byArray = bos.toByteArray_clear();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((Closeable)dos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toCompressedBytes(@Nonnull Externalizable obj, @Nonnull CompressionStreamFactory.CompressionAlgorithm algo, boolean bin2txt) throws IOException {
        byte[] byArray;
        FastMultiByteArrayOutputStream bos = new FastMultiByteArrayOutputStream();
        OutputStream out = null;
        FinishableOutputStream dos = null;
        try {
            out = bin2txt ? new Base91OutputStream(bos) : bos;
            dos = CompressionStreamFactory.createOutputStream(out, algo);
            ObjectUtils.toStream(obj, (OutputStream)dos);
            dos.finish();
            byArray = bos.toByteArray_clear();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(dos);
            IOUtils.closeQuietly((Closeable)out);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)dos);
        IOUtils.closeQuietly((Closeable)out);
        return byArray;
    }

    public static void toStream(@Nonnull Object obj, @Nonnull OutputStream out) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        oos.writeObject(obj);
        oos.flush();
    }

    public static void toStream(@Nonnull Externalizable obj, @Nonnull OutputStream out) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(out);
        obj.writeExternal(oos);
        oos.flush();
    }

    public static <T> T readObject(@Nonnull byte[] obj) throws IOException, ClassNotFoundException {
        return ObjectUtils.readObject(obj, obj.length);
    }

    public static <T> T readObject(@Nonnull byte[] obj, int length) throws IOException, ClassNotFoundException {
        return ObjectUtils.readObject(new FastByteArrayInputStream(obj, length));
    }

    public static void readObject(@Nonnull byte[] src, @Nonnull Externalizable dst) throws IOException, ClassNotFoundException {
        ObjectUtils.readObject(src, src.length, dst);
    }

    public static void readObject(@Nonnull byte[] src, int length, @Nonnull Externalizable dst) throws IOException, ClassNotFoundException {
        ObjectUtils.readObject(new FastByteArrayInputStream(src, length), dst);
    }

    public static <T> T readObject(@Nonnull InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(is);
        return (T)ois.readObject();
    }

    public static void readObject(@Nonnull InputStream is, @Nonnull Externalizable dst) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(is);
        dst.readExternal(ois);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T readCompressedObject(@Nonnull byte[] obj) throws IOException, ClassNotFoundException {
        FastByteArrayInputStream bis = new FastByteArrayInputStream(obj);
        InflaterInputStream iis = new InflaterInputStream(bis);
        try {
            T t = ObjectUtils.readObject(iis);
            return t;
        }
        finally {
            IOUtils.closeQuietly((Closeable)iis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readCompressedObject(@Nonnull byte[] src, @Nonnull Externalizable dst) throws IOException, ClassNotFoundException {
        FastByteArrayInputStream bis = new FastByteArrayInputStream(src);
        InflaterInputStream iis = new InflaterInputStream(bis);
        try {
            ObjectUtils.readObject(iis, dst);
        }
        finally {
            IOUtils.closeQuietly((Closeable)iis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readCompressedObject(@Nonnull byte[] src, int len, @Nonnull Externalizable dst, @Nonnull CompressionStreamFactory.CompressionAlgorithm algo, boolean bin2txt) throws IOException, ClassNotFoundException {
        FastByteArrayInputStream bis = new FastByteArrayInputStream(src, len);
        InputStream in = null;
        InputStream compressedStream = null;
        try {
            in = bin2txt ? new Base91InputStream(bis) : bis;
            compressedStream = CompressionStreamFactory.createInputStream(in, algo);
            ObjectUtils.readObject(compressedStream, dst);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(compressedStream);
            IOUtils.closeQuietly((Closeable)in);
            throw throwable;
        }
        IOUtils.closeQuietly((Closeable)compressedStream);
        IOUtils.closeQuietly((Closeable)in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readCompressedObject(@Nonnull byte[] src, int offset, int length, @Nonnull Externalizable dst) throws IOException, ClassNotFoundException {
        FastByteArrayInputStream bis = new FastByteArrayInputStream(src, offset, length);
        InflaterInputStream iis = new InflaterInputStream(bis);
        try {
            ObjectUtils.readObject(iis, dst);
        }
        finally {
            IOUtils.closeQuietly((Closeable)iis);
        }
    }

    public static <E extends Enum<E>> E fromOrdinal(Class<E> enumClass, int ordinal) {
        Enum[] enumArray = (Enum[])enumClass.getEnumConstants();
        return (E)enumArray[ordinal];
    }
}

