/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;

public final class OptionUtils {
    private OptionUtils() {
    }

    public static boolean getBoolean(@Nonnull Map<String, ?> options, @Nonnull String optionName) {
        Object value = options.get(optionName);
        if (value == null) {
            throw new NoSuchElementException("Could not find an option: " + optionName);
        }
        if (!(value instanceof Boolean)) {
            throw new IllegalStateException("Non-boolean unexpected value type: " + value.getClass().getSimpleName());
        }
        return (Boolean)value;
    }

    public static int getInt(@Nonnull Map<String, ?> options, @Nonnull String optionName) {
        Object value = options.get(optionName);
        if (value == null) {
            throw new NoSuchElementException("Could not find an option: " + optionName);
        }
        if (!(value instanceof Integer)) {
            throw new IllegalStateException("Non-integer unexpected value type: " + value.getClass().getSimpleName());
        }
        return (Integer)value;
    }

    public static long getLong(@Nonnull Map<String, ?> options, @Nonnull String optionName) {
        Object value = options.get(optionName);
        if (value == null) {
            throw new NoSuchElementException("Could not find an option: " + optionName);
        }
        if (!(value instanceof Long)) {
            throw new IllegalStateException("Non-long unexpected value type: " + value.getClass().getSimpleName());
        }
        return (Long)value;
    }

    public static double getDouble(@Nonnull Map<String, ?> options, @Nonnull String optionName) {
        Object value = options.get(optionName);
        if (value == null) {
            throw new NoSuchElementException("Could not find an option: " + optionName);
        }
        if (!(value instanceof Double)) {
            throw new IllegalStateException("Non-double unexpected value type: " + value.getClass().getSimpleName());
        }
        return (Double)value;
    }
}

