/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import javax.annotation.Nonnull;

public final class Primitives {
    public static final int INT_BYTES = 4;
    public static final int DOUBLE_BYTES = 8;
    public static final Byte TRUE_BYTE = 1;
    public static final Byte FALSE_BYTE = 0;

    private Primitives() {
    }

    public static short parseShort(String s, short defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Short.parseShort(s);
    }

    public static int parseInt(String s, int defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Integer.parseInt(s);
    }

    public static long parseLong(String s, long defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Long.parseLong(s);
    }

    public static float parseFloat(String s, float defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Float.parseFloat(s);
    }

    public static double parseDouble(String s, double defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Double.parseDouble(s);
    }

    public static boolean parseBoolean(String s, boolean defaultValue) {
        if (s == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(s);
    }

    public static double doubleValue(Double v, double defaultValue) {
        if (v == null) {
            return defaultValue;
        }
        return v;
    }

    public static boolean isFinite(double value) {
        return Double.NEGATIVE_INFINITY < value && value < Double.POSITIVE_INFINITY;
    }

    public static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public static void putChar(byte[] b, int off, char val) {
        b[off + 1] = (byte)(val >>> 0);
        b[off] = (byte)(val >>> 8);
    }

    public static long toLong(int high, int low) {
        return (long)high << 32 | (long)low & 0xFFFFFFFFL;
    }

    public static int getHigh(long key) {
        return (int)(key >>> 32) & 0xFFFFFFFF;
    }

    public static int getLow(long key) {
        return (int)key & 0xFFFFFFFF;
    }

    @Nonnull
    public static byte[] toBytes(long l) {
        byte[] retVal = new byte[8];
        for (int i = 0; i < 8; ++i) {
            retVal[i] = (byte)l;
            l >>= 8;
        }
        return retVal;
    }

    public static int hashCode(long value) {
        return (int)(value ^ value >>> 32);
    }
}

