/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class PrivilegedAccessor {
    public static Field getField(Class<?> clazz, String fieldName) {
        try {
            return PrivilegedAccessor.getField(clazz, fieldName, true);
        }
        catch (NoSuchFieldException e) {
            throw new Error(e);
        }
    }

    public static Field getField(final Class<?> clazz, final String fieldName, final boolean accessible) throws NoSuchFieldException {
        Field field;
        try {
            field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                @Override
                public Field run() throws NoSuchFieldException {
                    Field f = clazz.getDeclaredField(fieldName);
                    f.setAccessible(accessible);
                    return f;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new AssertionError((Object)e.getCause());
        }
        return field;
    }

    public static void setField(Object obj, final Class<?> clazz, final String fieldName, Object value) {
        Field field;
        try {
            field = AccessController.doPrivileged(new PrivilegedExceptionAction<Field>(){

                @Override
                public Field run() throws NoSuchFieldException {
                    Field f = clazz.getDeclaredField(fieldName);
                    f.setAccessible(true);
                    return f;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new AssertionError((Object)e.getCause());
        }
        try {
            field.set(obj, value);
        }
        catch (IllegalArgumentException arge) {
            throw new Error(arge);
        }
        catch (IllegalAccessException acce) {
            throw new Error(acce);
        }
    }

    public static void setField(Object obj, Field field, Object value) {
        try {
            field.set(obj, value);
        }
        catch (IllegalArgumentException arge) {
            throw new Error(arge);
        }
        catch (IllegalAccessException acce) {
            throw new Error(acce);
        }
    }

    public static Method getMethod(Class<?> thisClass, String methodName, Class<?>[] classTypes) throws NoSuchMethodException {
        if (thisClass == null) {
            throw new NoSuchMethodException("Class is not specified for method " + methodName + ".");
        }
        try {
            return thisClass.getDeclaredMethod(methodName, classTypes);
        }
        catch (NoSuchMethodException e) {
            return PrivilegedAccessor.getMethod(thisClass.getSuperclass(), methodName, classTypes);
        }
    }

    public static Method getMethod(Object instance, String methodName, Class<?>[] classTypes) throws NoSuchMethodException {
        Method accessMethod = PrivilegedAccessor.getMethod(instance.getClass(), methodName, classTypes);
        accessMethod.setAccessible(true);
        return accessMethod;
    }

    public static Object getValue(Object instance, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Field field = PrivilegedAccessor.getField(instance.getClass(), fieldName, true);
        return field.get(instance);
    }

    public static Object invokeMethod(Object instance, String methodName, Object arg) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return PrivilegedAccessor.invokeMethod(instance, methodName, args);
    }

    public static Object invokeMethod(Object instance, String methodName, Object ... args) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class[] classTypes = null;
        if (args != null) {
            classTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                classTypes[i] = args[i].getClass();
            }
        }
        return PrivilegedAccessor.getMethod(instance, methodName, classTypes).invoke(instance, args);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object arg) throws SecurityException, IllegalArgumentException, NoSuchMethodException, ClassNotFoundException, IllegalAccessException, InvocationTargetException {
        Object[] args = new Object[]{arg};
        return PrivilegedAccessor.invokeStaticMethod(className, methodName, args);
    }

    public static Object invokeStaticMethod(String className, String methodName, Object ... args) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> primeClass = Class.forName(className);
        Class[] classTypes = null;
        if (args != null) {
            classTypes = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (args[i] == null) continue;
                classTypes[i] = args[i].getClass();
            }
        }
        Method method = primeClass.getDeclaredMethod(methodName, classTypes);
        method.setAccessible(true);
        return method.invoke((Object)method, args);
    }

    public static Object invokeStaticMethod(String className, String methodName, Class<?>[] classTypes, Object ... objects) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> primeClass = Class.forName(className);
        Method method = primeClass.getDeclaredMethod(methodName, classTypes);
        method.setAccessible(true);
        return method.invoke((Object)method, objects);
    }
}

