/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang.mutable;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MutableBoolean
implements Comparable<MutableBoolean>,
Serializable {
    private static final long serialVersionUID = -8946436031470563775L;
    private boolean value;

    public MutableBoolean() {
        this(false);
    }

    public MutableBoolean(boolean value) {
        this.value = value;
    }

    public boolean get() {
        return this.value;
    }

    public boolean booleanValue() {
        return this.value;
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public void setValue(@Nonnull Boolean value) {
        this.value = value;
    }

    public void setFalse() {
        this.value = false;
    }

    public void setTrue() {
        this.value = true;
    }

    public int hashCode() {
        return this.value ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof MutableBoolean) {
            return this.value == ((MutableBoolean)other).booleanValue();
        }
        return false;
    }

    @Override
    public int compareTo(@Nonnull MutableBoolean o) {
        return Boolean.compare(this.value, o.value);
    }
}

