/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lang.mutable;

import hivemall.utils.lang.Copyable;
import java.io.Serializable;

public final class MutableInt
extends Number
implements Copyable<MutableInt>,
Comparable<MutableInt>,
Serializable {
    private static final long serialVersionUID = -3289272606407100628L;
    private int value;

    public MutableInt() {
    }

    public MutableInt(int value) {
        this.value = value;
    }

    public MutableInt(Number value) {
        this.value = value.intValue();
    }

    public int getAndIncrement() {
        int ret = this.value++;
        return ret;
    }

    public void incr() {
        ++this.value;
    }

    public void decr() {
        --this.value;
    }

    public void addValue(int o) {
        this.value += o;
    }

    public int get() {
        return this.value;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public void setValue(Number value) {
        this.value = value.intValue();
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void copyTo(MutableInt another) {
        another.setValue(this.value);
    }

    @Override
    public void copyFrom(MutableInt another) {
        this.value = another.value;
    }

    @Override
    public int compareTo(MutableInt other) {
        return MutableInt.compare(this.value, other.value);
    }

    private static int compare(int x, int y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MutableInt) {
            return this.value == ((MutableInt)obj).intValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

