/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.lock;

import hivemall.utils.lock.Lock;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TTASLock
implements Lock {
    private final AtomicBoolean state;

    public TTASLock() {
        this(false);
    }

    public TTASLock(boolean locked) {
        this.state = new AtomicBoolean(locked);
    }

    @Override
    public void lock() {
        while (this.state.get() || this.state.getAndSet(true)) {
        }
    }

    @Override
    public boolean tryLock() {
        if (this.state.get()) {
            return false;
        }
        return !this.state.getAndSet(true);
    }

    @Override
    public void unlock() {
        this.state.set(false);
    }

    @Override
    public boolean isLocked() {
        return this.state.get();
    }
}

