/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.math;

import hivemall.annotations.Experimental;

@Experimental
public final class FastMath {
    private FastMath() {
    }

    @Deprecated
    public static float sqrt(float x) {
        return x * FastMath.invSqrt(x);
    }

    @Deprecated
    public static double sqrt(double x) {
        return x * FastMath.invSqrt(x);
    }

    @Deprecated
    public static float invSqrt(float x) {
        float hx = 0.5f * x;
        int i = 1597463174 - (Float.floatToRawIntBits(x) >>> 1);
        float y = Float.intBitsToFloat(i);
        y *= 1.5f - hx * y * y;
        y *= 1.5f - hx * y * y;
        y *= 1.5f - hx * y * y;
        return y;
    }

    @Deprecated
    public static double invSqrt(double x) {
        double hx = 0.5 * x;
        long i = 6910469410427058089L - (Double.doubleToRawLongBits(x) >>> 1);
        double y = Double.longBitsToDouble(i);
        y *= 1.5 - hx * y * y;
        y *= 1.5 - hx * y * y;
        y *= 1.5 - hx * y * y;
        y *= 1.5 - hx * y * y;
        return y;
    }

    public static double log(double x) {
        return JafamaMath.log(x);
    }

    public static double log1p(double x) {
        return JafamaMath.log1p(x);
    }

    public static double exp(double x) {
        return JafamaMath.exp(x);
    }

    public static double expm1(double x) {
        return JafamaMath.expm1(x);
    }

    public static double sigmoid(double x) {
        return 1.0 / (1.0 + FastMath.exp(-x));
    }

    private static final class JafamaMath {
        static final double TWO_POW_52 = JafamaMath.twoPow(52);
        static final double DOUBLE_MIN_NORMAL = Double.longBitsToDouble(0x10000000000000L);
        static final int MIN_DOUBLE_EXPONENT = -1074;
        static final int MAX_DOUBLE_EXPONENT = 1023;
        static final double LOG_2 = StrictMath.log(2.0);
        static final double EXP_OVERFLOW_LIMIT = Double.longBitsToDouble(4649454530587146735L);
        static final double EXP_UNDERFLOW_LIMIT = Double.longBitsToDouble(-4573606559926636463L);
        static final int EXP_LO_DISTANCE_TO_ZERO_POT = 0;
        static final int EXP_LO_DISTANCE_TO_ZERO = 1;
        static final int EXP_LO_TAB_SIZE_POT = 11;
        static final int EXP_LO_TAB_SIZE = 2049;
        static final int EXP_LO_TAB_MID_INDEX = 1024;
        static final int EXP_LO_INDEXING = 1024;
        static final int EXP_LO_INDEXING_DIV_SHIFT = 10;
        static final int LOG_BITS = 12;
        static final int LOG_TAB_SIZE = 4096;

        private JafamaMath() {
        }

        static double exp(double value) {
            if (value > EXP_OVERFLOW_LIMIT) {
                return Double.POSITIVE_INFINITY;
            }
            if (!(value >= EXP_UNDERFLOW_LIMIT)) {
                return value != value ? Double.NaN : 0.0;
            }
            int indexes = (int)(value * 1024.0);
            int valueInt = indexes >= 0 ? indexes >> 10 : -(-indexes >> 10);
            double hiTerm = MyTExp.expHiTab[valueInt - (int)EXP_UNDERFLOW_LIMIT];
            int zIndex = indexes - (valueInt << 10);
            double y = value - (double)valueInt;
            double z = (double)zIndex * 9.765625E-4;
            double eps = y - z;
            double expZ = MyTExp.expLoPosTab[zIndex + 1024];
            double expEps = 1.0 + eps * (1.0 + eps * (0.5 + eps * (0.16666666666666666 + eps * 0.041666666666666664)));
            double loTerm = expZ * expEps;
            return hiTerm * loTerm;
        }

        static double expm1(double value) {
            if (Math.abs(value) < 1.0) {
                int i = (int)(value * 1024.0);
                double delta = value - (double)i * 9.765625E-4;
                return MyTExp.expLoPosTab[i + 1024] * (MyTExp.expLoNegTab[i + 1024] + delta * (1.0 + delta * (0.5 + delta * (0.16666666666666666 + delta * (0.041666666666666664 + delta * 0.008333333333333333)))));
            }
            return JafamaMath.exp(value) - 1.0;
        }

        static double log(double value) {
            if (value > 0.0) {
                double h;
                if (value == Double.POSITIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                if (value > 0.95) {
                    if (value < 1.14) {
                        double z = (value - 1.0) / (value + 1.0);
                        double z2 = z * z;
                        return z * (2.0 + z2 * (0.6666666666666666 + z2 * (0.4 + z2 * (0.2857142857142857 + z2 * (0.2222222222222222 + z2 * 0.18181818181818182)))));
                    }
                    h = 0.0;
                } else if (value < DOUBLE_MIN_NORMAL) {
                    value *= TWO_POW_52;
                    h = -52.0 * LOG_2;
                } else {
                    h = 0.0;
                }
                int valueBitsHi = (int)(Double.doubleToRawLongBits(value) >> 32);
                int valueExp = (valueBitsHi >> 20) - 1023;
                int xIndex = valueBitsHi << 12 >>> 20;
                double z = value * JafamaMath.twoPowNormalOrSubnormal(-valueExp) * MyTLog.logXInvTab[xIndex] - 1.0;
                z *= 1.0 - z * (0.5 - z * 0.3333333333333333);
                return h + (double)valueExp * LOG_2 + (MyTLog.logXLogTab[xIndex] + z);
            }
            if (value == 0.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.NaN;
        }

        static double log1p(double value) {
            if (value > -1.0) {
                if (value == Double.POSITIVE_INFINITY) {
                    return Double.POSITIVE_INFINITY;
                }
                double valuePlusOne = 1.0 + value;
                if (valuePlusOne == 1.0) {
                    return value;
                }
                if (Math.abs(value) < 0.15) {
                    double z = value / (value + 2.0);
                    double z2 = z * z;
                    return z * (2.0 + z2 * (0.6666666666666666 + z2 * (0.4 + z2 * (0.2857142857142857 + z2 * (0.2222222222222222 + z2 * 0.18181818181818182)))));
                }
                int valuePlusOneBitsHi = (int)(Double.doubleToRawLongBits(valuePlusOne) >> 32) & Integer.MAX_VALUE;
                int valuePlusOneExp = (valuePlusOneBitsHi >> 20) - 1023;
                int xIndex = valuePlusOneBitsHi << 12 >>> 20;
                double z = valuePlusOne * JafamaMath.twoPowNormalOrSubnormal(-valuePlusOneExp) * MyTLog.logXInvTab[xIndex] - 1.0;
                z *= 1.0 - z * (0.5 - z * 0.3333333333333333);
                return (double)valuePlusOneExp * LOG_2 + MyTLog.logXLogTab[xIndex] + (z + (value - (valuePlusOne - 1.0)) / valuePlusOne);
            }
            if (value == -1.0) {
                return Double.NEGATIVE_INFINITY;
            }
            return Double.NaN;
        }

        private static double twoPowNormalOrSubnormal(int power) {
            if (power <= -1023) {
                return Double.longBitsToDouble(0x8000000000000L >> -(power + 1023));
            }
            return Double.longBitsToDouble((long)(power + 1023) << 52);
        }

        private static double twoPow(int power) {
            if (power <= -1023) {
                if (power >= -1074) {
                    return Double.longBitsToDouble(0x8000000000000L >> -(power + 1023));
                }
                return 0.0;
            }
            if (power > 1023) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.longBitsToDouble((long)(power + 1023) << 52);
        }

        static final class MyTLog {
            static final double[] logXLogTab = new double[4096];
            static final double[] logXTab = new double[4096];
            static final double[] logXInvTab = new double[4096];

            MyTLog() {
            }

            private static strictfp void init() {
                for (int i = 0; i < 4096; ++i) {
                    double x = 1.0 + (double)i * 2.44140625E-4;
                    MyTLog.logXLogTab[i] = StrictMath.log(x);
                    MyTLog.logXTab[i] = x;
                    MyTLog.logXInvTab[i] = 1.0 / x;
                }
            }

            static {
                MyTLog.init();
            }
        }

        static final class MyTExp {
            static final double[] expHiTab = new double[1 + (int)EXP_OVERFLOW_LIMIT - (int)EXP_UNDERFLOW_LIMIT];
            static final double[] expLoPosTab = new double[2049];
            static final double[] expLoNegTab = new double[2049];

            MyTExp() {
            }

            private static strictfp void init() {
                int i;
                for (i = (int)EXP_UNDERFLOW_LIMIT; i <= (int)EXP_OVERFLOW_LIMIT; ++i) {
                    MyTExp.expHiTab[i - (int)JafamaMath.EXP_UNDERFLOW_LIMIT] = StrictMath.exp(i);
                }
                for (i = 0; i < 2049; ++i) {
                    double x = -1.0 + (double)i / 1024.0;
                    MyTExp.expLoPosTab[i] = StrictMath.exp(x);
                    MyTExp.expLoNegTab[i] = -StrictMath.expm1(-x);
                }
            }

            static {
                MyTExp.init();
            }
        }
    }
}

