/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.net;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.util.NoSuchElementException;

public final class NetUtils {
    private NetUtils() {
    }

    public static InetSocketAddress getInetSocketAddress(String endpointURI, int defaultPort) {
        int pos = endpointURI.indexOf(58);
        if (pos == -1) {
            InetAddress addr = NetUtils.getInetAddress(endpointURI);
            return new InetSocketAddress(addr, defaultPort);
        }
        String host = endpointURI.substring(0, pos);
        InetAddress addr = NetUtils.getInetAddress(host);
        String portStr = endpointURI.substring(pos + 1);
        int port = Integer.parseInt(portStr);
        return new InetSocketAddress(addr, port);
    }

    public static InetAddress getInetAddress(String addressOrName) {
        try {
            return InetAddress.getByName(addressOrName);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Cannot find InetAddress: " + addressOrName);
        }
    }

    public static boolean isIPAddress(String ip) {
        return ip.matches("^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$");
    }

    public static int getAvailablePort() {
        try {
            ServerSocket s = new ServerSocket(0);
            s.setReuseAddress(true);
            s.close();
            return s.getLocalPort();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to find an available port", e);
        }
    }

    public static int getAvailablePort(int basePort) {
        if (basePort == 0) {
            return NetUtils.getAvailablePort();
        }
        if (basePort < 0 || basePort > 65535) {
            throw new IllegalArgumentException("Illegal port number: " + basePort);
        }
        for (int i = basePort; i <= 65535; ++i) {
            if (!NetUtils.isPortAvailable(i)) continue;
            return i;
        }
        throw new NoSuchElementException("Could not find available port greater than or equals to " + basePort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isPortAvailable(int port) {
        ServerSocket s = null;
        try {
            s = new ServerSocket(port);
            s.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

