/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.random;

import hivemall.utils.lang.Primitives;
import hivemall.utils.random.CommonsMathRandom;
import hivemall.utils.random.JavaRandom;
import hivemall.utils.random.PRNG;
import hivemall.utils.random.SmileRandom;
import java.security.SecureRandom;
import javax.annotation.Nonnull;
import org.apache.commons.math3.random.MersenneTwister;
import smile.math.random.MersenneTwister64;

public final class RandomNumberGeneratorFactory {
    private RandomNumberGeneratorFactory() {
    }

    @Nonnull
    public static PRNG createPRNG() {
        return RandomNumberGeneratorFactory.createPRNG(PRNGType.smile);
    }

    @Nonnull
    public static PRNG createPRNG(long seed) {
        return RandomNumberGeneratorFactory.createPRNG(PRNGType.smile, seed);
    }

    @Nonnull
    public static PRNG createPRNG(@Nonnull PRNGType type) {
        PRNG rng;
        switch (type) {
            case java: {
                rng = new JavaRandom();
                break;
            }
            case secure: {
                rng = new JavaRandom(new SecureRandom());
                break;
            }
            case smile: {
                rng = new SmileRandom();
                break;
            }
            case smileMT: {
                rng = new SmileRandom(new smile.math.random.MersenneTwister());
                break;
            }
            case smileMT64: {
                rng = new SmileRandom(new MersenneTwister64());
                break;
            }
            case commonsMath3MT: {
                rng = new CommonsMathRandom(new MersenneTwister());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + (Object)((Object)type));
            }
        }
        return rng;
    }

    @Nonnull
    public static PRNG createPRNG(@Nonnull PRNGType type, long seed) {
        PRNG rng;
        switch (type) {
            case java: {
                rng = new JavaRandom(seed);
                break;
            }
            case secure: {
                rng = new JavaRandom(new SecureRandom(Primitives.toBytes(seed)));
                break;
            }
            case smile: {
                rng = new SmileRandom(seed);
                break;
            }
            case smileMT: {
                rng = new SmileRandom(new smile.math.random.MersenneTwister(Primitives.hashCode(seed)));
                break;
            }
            case smileMT64: {
                rng = new SmileRandom(new MersenneTwister64(seed));
                break;
            }
            case commonsMath3MT: {
                rng = new CommonsMathRandom(new MersenneTwister(seed));
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected type: " + (Object)((Object)type));
            }
        }
        return rng;
    }

    public static enum PRNGType {
        java,
        secure,
        smile,
        smileMT,
        smileMT64,
        commonsMath3MT;

    }
}

