/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.sampling;

import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nonnull;

public final class IntReservoirSampler {
    private final int[] samples;
    private final int numSamples;
    private int position;
    private final Random rand;

    public IntReservoirSampler(int sampleSize) {
        if (sampleSize <= 0) {
            throw new IllegalArgumentException("sampleSize must be greater than 1: " + sampleSize);
        }
        this.samples = new int[sampleSize];
        this.numSamples = sampleSize;
        this.position = 0;
        this.rand = new Random();
    }

    public IntReservoirSampler(int sampleSize, long seed) {
        this.samples = new int[sampleSize];
        this.numSamples = sampleSize;
        this.position = 0;
        this.rand = new Random(seed);
    }

    public IntReservoirSampler(int[] samples) {
        this.samples = samples;
        this.numSamples = samples.length;
        this.position = 0;
        this.rand = new Random();
    }

    public IntReservoirSampler(int[] samples, long seed) {
        this.samples = samples;
        this.numSamples = samples.length;
        this.position = 0;
        this.rand = new Random(seed);
    }

    public int size() {
        return this.position;
    }

    @Nonnull
    public int[] getSample() {
        if (this.position >= this.numSamples) {
            return this.samples;
        }
        return Arrays.copyOf(this.samples, this.position);
    }

    public void add(int item) {
        if (this.position < this.numSamples) {
            this.samples[this.position] = item;
        } else {
            int replaceIndex = this.rand.nextInt(this.position + 1);
            if (replaceIndex < this.numSamples) {
                this.samples[replaceIndex] = item;
            }
        }
        ++this.position;
    }

    public void clear() {
        Arrays.fill(this.samples, 0);
        this.position = 0;
    }
}

