/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.stats;

import hivemall.utils.collections.DoubleRingBuffer;
import hivemall.utils.lang.NumberUtils;
import hivemall.utils.lang.Preconditions;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class MovingAverage {
    @Nonnull
    private final DoubleRingBuffer ring;
    private double totalSum;

    public MovingAverage(@Nonnegative int windowSize) {
        Preconditions.checkArgument(windowSize > 1, "Invalid window size: " + windowSize);
        this.ring = new DoubleRingBuffer(windowSize);
        this.totalSum = 0.0;
    }

    public double add(double x) {
        if (!NumberUtils.isFinite(x)) {
            throw new IllegalArgumentException("Detected Infinite input: " + x);
        }
        if (this.ring.isFull()) {
            double head = this.ring.head();
            this.totalSum -= head;
        }
        this.ring.add(x);
        this.totalSum += x;
        int size = this.ring.size();
        if (size == 0) {
            return 0.0;
        }
        return this.totalSum / (double)size;
    }

    public double get() {
        int size = this.ring.size();
        if (size == 0) {
            return 0.0;
        }
        return this.totalSum / (double)size;
    }

    public String toString() {
        return "MovingAverage [ring=" + this.ring + ", total=" + this.totalSum + ", moving_avg=" + this.get() + "]";
    }
}

