/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.stats;

public final class OnlineVariance {
    private long n;
    private double mean;
    private double m2;

    public OnlineVariance() {
        this.reset();
    }

    public void reset() {
        this.n = 0L;
        this.mean = 0.0;
        this.m2 = 0.0;
    }

    public void handle(double x) {
        ++this.n;
        double delta = x - this.mean;
        this.mean += delta / (double)this.n;
        this.m2 += delta * (x - this.mean);
    }

    public void unhandle(double x) {
        if (this.n == 0L) {
            return;
        }
        if (this.n == 1L) {
            this.reset();
            return;
        }
        double old_mean = ((double)this.n * this.mean - x) / (double)(this.n - 1L);
        this.m2 -= (x - this.mean) * (x - old_mean);
        this.mean = old_mean;
        --this.n;
    }

    public long numSamples() {
        return this.n;
    }

    public double mean() {
        return this.mean;
    }

    public double variance() {
        return this.n > 1L ? this.m2 / (double)(this.n - 1L) : 0.0;
    }

    public double stddev() {
        return Math.sqrt(this.variance());
    }
}

