/*
 * Decompiled with CFR 0.152.
 */
package hivemall.utils.stream;

import hivemall.utils.io.DeflaterOutputStream;
import hivemall.utils.io.FastByteArrayInputStream;
import hivemall.utils.io.FastMultiByteArrayOutputStream;
import hivemall.utils.io.IOUtils;
import hivemall.utils.stream.IntIterator;
import hivemall.utils.stream.IntStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public final class StreamUtils {
    private StreamUtils() {
    }

    @Nonnull
    public static IntStream toCompressedIntStream(@Nonnull int[] src) {
        return StreamUtils.toCompressedIntStream(src, -1);
    }

    @Nonnull
    public static IntStream toCompressedIntStream(@Nonnull int[] src, int level) {
        byte[] compressed;
        FastMultiByteArrayOutputStream bos = new FastMultiByteArrayOutputStream(16384);
        Deflater deflater = new Deflater(level, true);
        DeflaterOutputStream defos = new DeflaterOutputStream((OutputStream)bos, deflater, 8192);
        DataOutputStream dos = new DataOutputStream(defos);
        int count = src.length;
        try {
            for (int i = 0; i < count; ++i) {
                dos.writeInt(src[i]);
            }
            defos.finish();
            compressed = bos.toByteArray_clear();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to compress int[]", e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)dos);
        }
        return new InflateIntStream(compressed, count);
    }

    @Nonnull
    public static IntStream toArrayIntStream(@Nonnull int[] array) {
        return new ArrayIntStream(array);
    }

    static final class InflatedIntIterator
    implements IntIterator {
        @Nonnull
        private final DataInputStream in;
        @Nonnegative
        private final int count;
        @Nonnegative
        private int index;

        InflatedIntIterator(@Nonnull DataInputStream in, @Nonnegative int count) {
            this.in = in;
            this.count = count;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        @Override
        public int next() {
            if (this.index < this.count) {
                int v;
                try {
                    v = this.in.readInt();
                }
                catch (IOException e) {
                    throw new IllegalStateException("Invalid input at " + this.index, e);
                }
                ++this.index;
                return v;
            }
            throw new NoSuchElementException();
        }
    }

    static final class InflateIntStream
    implements IntStream {
        @Nonnull
        private final byte[] compressed;
        @Nonnegative
        private final int count;

        InflateIntStream(@Nonnull byte[] compressed, @Nonnegative int count) {
            this.compressed = compressed;
            this.count = count;
        }

        @Override
        public InflatedIntIterator iterator() {
            FastByteArrayInputStream bis = new FastByteArrayInputStream(this.compressed);
            InflaterInputStream infis = new InflaterInputStream(bis, new Inflater(true), 512);
            DataInputStream in = new DataInputStream(infis);
            return new InflatedIntIterator(in, this.count);
        }
    }

    static final class ArrayIntIterator
    implements IntIterator {
        @Nonnull
        private final int[] array;
        @Nonnegative
        private final int count;
        @Nonnegative
        private int index;

        ArrayIntIterator(@Nonnull int[] array) {
            this.array = array;
            this.count = array.length;
            this.index = 0;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.count;
        }

        @Override
        public int next() {
            if (this.index < this.count) {
                return this.array[this.index++];
            }
            throw new NoSuchElementException();
        }
    }

    static final class ArrayIntStream
    implements IntStream {
        @Nonnull
        private final int[] array;

        ArrayIntStream(@Nonnull int[] array) {
            this.array = array;
        }

        @Override
        public ArrayIntIterator iterator() {
            return new ArrayIntIterator(this.array);
        }
    }
}

